package com.bcxin.ars.dao.sb;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.sb.Armtrainorg;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/18 0018 10:57
 */
@Service
public class ArmtrainorgDaoAop {


    @Autowired
    private ArmtrainorgDao armtrainorgDao;

    @DataChangeAnnotation(getEntityClazz = Armtrainorg.class,
            getDaoClazz = ArmtrainorgDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateCensorStatus(Armtrainorg armtrainorg){
        armtrainorgDao.updateCensorStatus(armtrainorg);
    }

    @DataChangeAnnotation(getEntityClazz = Armtrainorg.class,
            getDaoClazz = ArmtrainorgDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(Armtrainorg armtrainorg){
        armtrainorgDao.update(armtrainorg);
    }

    @DataChangeAnnotation(getEntityClazz = Armtrainorg.class,
            getDaoClazz = ArmtrainorgDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updateBatch(List<Armtrainorg> list){
        armtrainorgDao.updateBatch(list);
    }
}
