package com.bcxin.ars.dao.certificate;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.certificate.GradeAppraisalCer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/03 0003 11:09
 */
@Service
public class GradeAppraisalCerDaoAop {

    @Autowired
    private GradeAppraisalCerDao gradeAppraisalCerDao;


    @DataChangeAnnotation(getEntityClazz = GradeAppraisalCer.class,
            getDaoClazz = GradeAppraisalCerDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateSelective(GradeAppraisalCer gradeAppraisalCer) {
        gradeAppraisalCerDao.updateSelective(gradeAppraisalCer);
    }

    @DataChangeAnnotation(getEntityClazz = GradeAppraisalCer.class,
            getDaoClazz = GradeAppraisalCerDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<GradeAppraisalCer> list) {
        gradeAppraisalCerDao.saveBatch(list);
    }
}
