package com.bcxin.ars.dao;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.ProblemPerson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/18 0018 10:02
 */
@Service
public class ProblemPersonDaoAop {

    @Autowired
    private ProblemPersonDao problemPersonDao;

    @DataChangeAnnotation(getEntityClazz = ProblemPerson.class,
            getDaoClazz = ProblemPersonDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(ProblemPerson problemPerson){
        problemPersonDao.update(problemPerson);
    }

    @DataChangeAnnotation(getEntityClazz = ProblemPerson.class,
            getDaoClazz = ProblemPersonDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void delete(ProblemPerson problemPerson){
        problemPersonDao.delete(problemPerson);
    }

    @DataChangeAnnotation(getEntityClazz = ProblemPerson.class,
            getDaoClazz = ProblemPersonDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateDS(ProblemPerson problemPerson){
        problemPersonDao.updateDS(problemPerson);
    }

    @DataChangeAnnotation(getEntityClazz = ProblemPerson.class,
            getDaoClazz = ProblemPersonDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateForCompany(ProblemPerson problemPerson){
        problemPersonDao.updateForCompany(problemPerson);
    }

    @DataChangeAnnotation(getEntityClazz = ProblemPerson.class,
            getDaoClazz = ProblemPersonDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void saveSingle(ProblemPerson problemPerson){
        problemPersonDao.saveSingle(problemPerson);
    }

    @DataChangeAnnotation(getEntityClazz = ProblemPerson.class,
            getDaoClazz = ProblemPersonDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateNewId(ProblemPerson problemPerson){
        problemPersonDao.updateNewId(problemPerson);
    }

    @DataChangeAnnotation(getEntityClazz = ProblemPerson.class,
            getDaoClazz = ProblemPersonDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateOrgInfo(ProblemPerson problemPerson){
        problemPersonDao.updateOrgInfo(problemPerson);
    }

    @DataChangeAnnotation(getEntityClazz = ProblemPerson.class,
            getDaoClazz = ProblemPersonDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateCompanyInfo(ProblemPerson problemPerson){
        problemPersonDao.updateCompanyInfo(problemPerson);
    }


    @DataChangeAnnotation(getEntityClazz = ProblemPerson.class,
            getDaoClazz = ProblemPersonDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = Long[].class,
            getSearchMethodName = "findByNewIdArrWithOutCache")
    public void updateReadstateByidArr(Long[] idArray){
        problemPersonDao.updateReadstateByidArr(idArray);
    }

    @DataChangeAnnotation(getEntityClazz = ProblemPerson.class,
            getDaoClazz = ProblemPersonDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<ProblemPerson> list){
        problemPersonDao.saveBatch(list);
    }
}
