package com.bcxin.ars.dao.task;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskPersonSchedule;
import com.bcxin.ars.model.task.TaskPersonScheduleDetail;

/**
 * 任务人员排班数据类
 * @author Ethan
 */
public interface TaskPersonScheduleDao {

	/**
	 * 新增排班
	 * @param personSchedule
	 * @return
	 */
	Long save(TaskPersonSchedule personSchedule);
	
	/**
	 * 新增排班明细
	 * @param personScheduleDetail
	 * @return
	 */
	Long saveDetail(TaskPersonScheduleDetail personScheduleDetail);
	
	/**
	 * 清空指定任务下的排班信息
	 * @param task
	 */
	void deleteByTaskPersonId(Long taskPersonId);
	
	/**
	 * 根据人员排班删除班次列表
	 * @param personSchedule
	 */
	void deleteDetailByPersonSchedule(TaskPersonSchedule personSchedule);
	
	/**
	 * 获取指定任务下指定人员的排班列表
	 * @param taskPersonId
	 * @return
	 */
	List<TaskPersonSchedule> findByTaskPersonId(Long taskPersonId);

	List<TaskPersonSchedule> findByTaskPersonIdStatus(Long id, Boolean b);


	/***
	 * 删除未接受人员的任务班次的关联，且任务已经结束
	 * @param endlist
	 */
	void deleteUnAccept(List<Task> endlist);
	/***
	 * 删除未接受人员的任务班次详细的关联，且任务已经结束
	 * @param endlist
	 */
	void deleteUnAcceptDetail(List<Task> endlist);
	
	List<TaskPersonSchedule> searchForDataSynchronization(DataSynchronizationSearchDto dto);
}
