package com.bcxin.ars.dao.task;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.task.TaskPersonDto;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskPerson;

/**
 * 任务人员数据类
 * @author Ethan
 */
public interface TaskPersonDao {

	/**
	 * 新增任务中人员
	 * @param taskPerson
	 * @return
	 */
	Long save(TaskPerson taskPerson);
	
	/**
	 * 
	 * <b>Function </b> 修改任务中人员的接受状态
	 * 
	 * @param taskPerson
	 * @注意事项 </b>
	 * <b>
	 */
	void update(TaskPerson taskPerson);
	
	/**
	 * 清空指定任务下的人员列表
	 * @param task
	 */
	void deleteByTask(Task task);
	
	/**
	 * 获取指定任务下指定人员列表
	 * @param task
	 * @return
	 */
	List<TaskPerson> findByTaskId(Long taskId);
	
	/**
	 * 获取指定任务指定人员的信息
	 * @param task
	 * @return
	 */
	TaskPerson findByTaskIdPersonId(Long taskId,Long personId);

	/**
	 * 获取指定人员的信息
	 * @param task
	 * @return
	 */
	List<TaskPerson> findByPersonId(Long personId);


	/**
	 *
	 * 更新人员接受状态
	 * @param endlist
	 * @param personid
	 * @注意事项 </b>
	 * <b>
	 */
	void updateState(List<Task> endlist,Long personid);


	/***
	 * 删除未接受人员与任务关系
	 * @param endlist 任务列表
	 */
	void updateUnAccept();

	/**
	 * 
	 * <b>Function </b> 
	 * 更新人员已完成任务状态
	 * @author LinQingLin 
	 * @date 2017年6月19日 下午7:15:57
	 * @注意事项 </b>
	 * <b>
	 */
	void updateFinish();
	
	List<TaskPerson> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	List<TaskPerson> findUnAcceptByPersonId(Long id);

	void delete(TaskPerson dbTaskPerson);
	
	List<TaskPersonDto> findTaskPersonsByTaskId(Long taskid);

	/**
	 * 查询部分字段
	 * @param taskId
	 * @param personId
	 * @return
	 */
	TaskPerson findStatusByTaskIdPersonId(Long taskId,Long personId);
}
