package com.bcxin.ars.dao.task;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.task.PersonClockInDto;
import com.bcxin.ars.model.task.PerTaskCardRecord;
import com.bcxin.ars.model.task.PersonClockIn;

import java.util.List;

/**
 * 人员打卡记录详情Dao
 */
public interface PersonClockInDao {
    PersonClockIn selectPerClockIn(PersonClockInDto personClockInDto);

    int save(PersonClockIn personClockIn);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<PerTaskCardRecord> findByBatchId(List<PersonClockIn> list);

    /**
     * 外网同步到内网查询
     * @param dto
     * @return
     */
    List<PersonClockIn> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(List<PersonClockIn> list);
}
