package com.bcxin.ars.dao.task;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.task.PersonClockInDto;
import com.bcxin.ars.model.task.PerTaskCardRecord;
import com.bcxin.ars.dto.page.task.PerTaskCardRecordPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *任务打卡记录Dao
 * @author linqinglin
 * @Date 2020-03-26 09:39:54
 */
public interface PerTaskCardRecordDao {

   /****
     * 删除
     * @param perTaskCardRecord
     * @return
     */
    int delete(PerTaskCardRecord perTaskCardRecord);

    /****
     * 保存
     * @param perTaskCardRecord
     * @return
     */
    int save(PerTaskCardRecord perTaskCardRecord);

    /****
     * 新增
     * @param perTaskCardRecord
     * @return
     */
    int insert(PerTaskCardRecord perTaskCardRecord);

    /****
     * 选择性插入
     * @param perTaskCardRecord
     * @return
     */
    int insertSelective(PerTaskCardRecord perTaskCardRecord);

    /****
     * 主键查询
     * @param id
     * @return
     */
    PerTaskCardRecord findById(Long id);

    /****
     * 修改
     * @param perTaskCardRecord
     * @return
     */
    int update(PerTaskCardRecord perTaskCardRecord);

    /****
     * 选择修改
     * @param perTaskCardRecord
     * @return
     */
    int updateSelective(PerTaskCardRecord perTaskCardRecord);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<PerTaskCardRecord> searchForPage(PerTaskCardRecordPageSearchDto searchDto, AjaxPageResponse<PerTaskCardRecord> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<PerTaskCardRecord> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<PerTaskCardRecord> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<PerTaskCardRecord> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<PerTaskCardRecord> findByBatchId(@Param("list") List<PerTaskCardRecord> list);

  /**
   * 查询打卡记录详情
   * @param perId
   * @return
   */
     PersonClockInDto selectPerClockInDto(Long perId);
}
