package com.bcxin.ars.dao.task;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.task.ComTaskPer;
import com.bcxin.ars.model.task.ComTaskSchedul;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *任务排班制明细Dao
 * @author linqinglin
 * @Date 2020-03-24 16:43:05
 */
public interface ComTaskSchedulDao {

   /****
     * 删除
     * @param comTaskSchedul
     * @return
     */
    int delete(ComTaskSchedul comTaskSchedul);

    /****
     * 保存
     * @param comTaskSchedul
     * @return
     */
    int save(ComTaskSchedul comTaskSchedul);

    /****
     * 新增
     * @param comTaskSchedul
     * @return
     */
    int insert(ComTaskSchedul comTaskSchedul);

    /****
     * 选择性插入
     * @param comTaskSchedul
     * @return
     */
    int insertSelective(ComTaskSchedul comTaskSchedul);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ComTaskSchedul findById(Long id);

    /****
     * 修改
     * @param comTaskSchedul
     * @return
     */
    int update(ComTaskSchedul comTaskSchedul);

    /****
     * 选择修改
     * @param comTaskSchedul
     * @return
     */
    int updateSelective(ComTaskSchedul comTaskSchedul);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComTaskSchedul> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ComTaskSchedul> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<ComTaskSchedul> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComTaskSchedul> findByBatchId(@Param("list") List<ComTaskSchedul> list);

    void deleteByTaskIdPerIdsAndTime(@Param("comTaskId")Long comTaskId, @Param("perIds")List<String> perIds, @Param("startDate")String startDate, @Param("endDate")String endDate);

    void deleteBatchByTaskIdPerIds(@Param("list")List<ComTaskPer> removeList);

    void deleteByTaskId(@Param("comTaskId")Long comTaskId);

    void deleteByTaskIds(@Param("list") Long[] taskIdList);
}
