package com.bcxin.ars.dao.sys;


import com.bcxin.ars.model.sys.ConfigSyncData;
import org.apache.ibatis.annotations.Param;
import java.util.List;
import java.util.Map;

public interface SyncDataDao {

    /**
     * 获取同步配置列表
     * by llc 2018-09-03
     */
    List<ConfigSyncData> getConfigSyncDataList();


    /**
     * 获取批次ID
     *
     * @param sequence by llc 2018-09-03
     */
    Long getNextVal(String sequence);

    /**
     * 插入Armorgcharge 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncArmorgcharge(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Armorgteach 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncArmorgteach(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Armtraincharge 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncArmtraincharge(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入CyFirearmsLog 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncCyFirearmsLog(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入CyServerht 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncCyServerht(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入VehicleLog 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncVehicleLog(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Datasync 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncDatasync(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入NewsnoticeCompany 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncNewsnoticeCompany(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入NewsnoticePolice 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncNewsnoticePolice(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入NewsnoticeRecipient 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncNewsnoticeRecipient(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入NewsCompanyRelationship 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncNewsCompanyRelationship(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Order 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncOrder(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入OrderPerson 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncOrderPerson(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入OrderTransaction 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncOrderTransaction(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Organization 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncOrganization(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Police 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncPolice(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入PoliceRole 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncPoliceRole(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Role 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncRole(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Armtrainorg 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncArmtrainorg(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SbBusinessManagement 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSbBusinessManagement(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SbBusinessOutsideManagement 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSbBusinessOutsideManagement(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Confesscompany 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncConfesscompany(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Confesscompanyundo 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncConfesscompanyundo(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Crosscompany 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncCrosscompany(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Family 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncFamily(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Firearms 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncFirearms(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Investor 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncInvestor(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Legalchange 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncLegalchange(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Legalchangeworkexperience 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncLegalchangeworkexperience(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入ManagementInfo 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncManagementInfo(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Personcertificate 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncPersoncertificate(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Personworkexperience 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncPersonworkexperience(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SbPunish 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSbPunish(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SbReward 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSbReward(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Safety 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSafety(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Shareholder 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncShareholder(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Sponsorlicense 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSponsorlicense(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SbSponsorlicenseManager 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSbSponsorlicenseManager(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SbSponsorlicenseVmanager 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSbSponsorlicenseVmanager(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Subsidiary 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSubsidiary(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Subsidiaryperson 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSubsidiaryperson(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SbSubsidiaryBase 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSbSubsidiaryBase(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SbSubsidiaryManager 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSbSubsidiaryManager(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Traincompanyapply 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncTraincompanyapply(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Vehicle 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncVehicle(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Workexperience 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncWorkexperience(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入YearReportInsurance 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncYearReportInsurance(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入YearReportInvestor 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncYearReportInvestor(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SecurityCertificate 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSecurityCertificate(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SecurityCompany 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSecurityCompany(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SecurityCompanyInsurance 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSecurityCompanyInsurance(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SecurityCompanySchedule 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSecurityCompanySchedule(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SecurityGoodThing 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSecurityGoodThing(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SecurityPerson 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSecurityPerson(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Approval 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncApproval(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入SysAttachment 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncSysAttachment(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Task 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncTask(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入TaskFeedback 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncTaskFeedback(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入TrainExamInfo 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncTrainExamInfo(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入TrainExamPerson 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncTrainExamPerson(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入User 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncUser(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);

    /**
     * 插入Yearreport 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncYearreport(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);


    /**
     * 插入YearreportdataManager 临时表
     *
     * @param list
     * @param syncBatchId
     * @return int
     * by llc 2018-08-30
     */
    int insertSyncYearreportdataManager(@Param("list") List<Map<String, Object>> list, @Param("syncBatchId") Long syncBatchId);


    /**
     * 数据同步插入动态sql
     *
     * @param map
     * @return int
     * by llc 2018-08-30
     */
    int executeInsertSql(Map<String, Object> map);

    /**
     * 数据同步更新动态sql
     *
     * @param map
     * @return int
     * by llc 2018-08-30
     */
    int executeUpdateSql(Map<String, Object> map);


    /**
     * 数据同步删除动态sql
     *
     * @param map
     * @return int
     * by llc 2018-08-30
     */
    int executeDeleteSql(Map<String, Object> map);

    /**
     * 数据同步查询动态sql
     *
     * @param map
     * @return List
     * by llc 2018-09-07
     */
    List<Map<String,Object>> executeSelectSql(Map<String, Object> map);
    /**
     *
     * @Decription:插入临时表
     * @author：zhongjianhui
     * @method  insertSync
     * @date：2018/9/18 13:43
     * @params： * @param map
     * @return int
     */
    int insertSync(Map<String, Object> map);
    /**
     *
     * @Decription:插入正式表
     * @author：zhongjianhui
     * @method  insertSync
     * @date：2018/9/18 13:43
     * @params： * @param map
     * @return int
     */
    int insertSql(Map<String, Object> map);
    /**
     *
     * @Decription:更新正式表
     * @author：zhongjianhui
     * @method  insertSync
     * @date：2018/9/18 13:43
     * @params： * @param map
     * @return int
     */
    int updateSql(Map<String, Object> map);
    /**
     *
     * @Decription:删除临时表
     * @author：zhongjianhui
     * @method  insertSync
     * @date：2018/9/18 13:43
     * @params： * @param map
     * @return int
     */
    int  deleteSql(Map<String, Object> map);

}