package com.bcxin.ars.dao.sys;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.sys.ModulePermission;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *公安权限Dao
 * @author linqinglin
 * @Date 2020-07-15 15:20:10
 */
public interface ModulePermissionDao {

   /****
     * 删除
     * @param modulePermission
     * @return
     */
    int delete(ModulePermission modulePermission);

    void deleteByRoleId(@Param("roleId") Long roleId);

    /****
     * 保存
     * @param modulePermission
     * @return
     */
    int save(ModulePermission modulePermission);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ModulePermission findById(Long id);

    /****
     * 选择修改
     * @param modulePermission
     * @return
     */
    int updateSelective(ModulePermission modulePermission);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<ModulePermission> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ModulePermission> findByBatchId(@Param("list") List<ModulePermission> list);

    List<ModulePermission> findByRoleId(@Param("roleId")Long roleId);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ModulePermission> findDSOutList(String startDate);
}
