package com.bcxin.ars.dao.sys;

import com.bcxin.ars.dto.LayTree;
import com.bcxin.ars.dto.MenuTree;
import com.bcxin.ars.dto.page.ModuleMenuPageSearchDto;
import com.bcxin.ars.dto.sys.MenuDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ModuleMenu;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *功能权限表Dao
 * @author linqinglin
 * @Date 2020-03-27 14:35:21
 */
public interface ModuleMenuDao {

    /****
     * 保存
     * @param moduleMenu
     * @return
     */
    int save(ModuleMenu moduleMenu);

    /**
     * 删除
     * @param moduleMenu
     * @return
     */
    int delete(ModuleMenu moduleMenu);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ModuleMenu findById(Long id);

    /****
     * 选择修改
     * @param moduleMenu
     * @return
     */
    int updateSelective(ModuleMenu moduleMenu);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<ModuleMenu> searchForPage(ModuleMenuPageSearchDto searchDto, AjaxPageResponse<ModuleMenu> page);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ModuleMenu> findByBatchId(@Param("list") List<ModuleMenu> list);

    Integer getMaxSeq(@Param("parentId") Long parentId);

    void updateSeq(ModuleMenu moduleMenu);

    List<ModuleMenu> findByUserAndMenuType(@Param("user") User user,@Param("menuType")String menuType);

    List<ModuleMenu> findForPermission(@Param("user") User user);

    List<MenuTree> findMenuTreeForPermission(@Param("user") User user, @Param("roleId") Long roleId);

    List<ModuleMenu> getOldData1();
    List<ModuleMenu> getOldData2(@Param("moduleType") String moduleType);
    List<ModuleMenu> getOldData3(@Param("moduleType") String moduleType);

    List<LayTree> findForLayTree(@Param("user") User user);

    ModuleMenu findByUniqueId(String uniqueId);

    List<MenuDto> searchForGX();
}
