package com.bcxin.ars.dao.sys;

import com.bcxin.ars.dto.BankAccountExportDto;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.BankAccountPageSearchDto;
import com.bcxin.ars.model.sys.BankAccount;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *银行账号信息Dao
 * @author linqinglin
 * @Date 2020-05-13 14:37:13
 */
public interface BankAccountDao {

   /****
     * 删除
     * @param bankAccount
     * @return
     */
    int delete(BankAccount bankAccount);

    /****
     * 保存
     * @param bankAccount
     * @return
     */
    int save(BankAccount bankAccount);

    /****
     * 主键查询
     * @param id
     * @return
     */
    BankAccount findById(Long id);

    /****
     * 选择修改
     * @param bankAccount
     * @return
     */
    int updateSelective(BankAccount bankAccount);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<BankAccountExportDto> searchForPage(BankAccountPageSearchDto searchDto, AjaxPageResponse<BankAccountExportDto> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<BankAccount> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<BankAccount> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<BankAccount> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<BankAccount> findByBatchId(@Param("list") List<BankAccount> list);


   /**
    * 根据身份证查询
    * @param idNum
    * @return
    */
    BankAccount findByIdNum(String idNum);

    List<BankAccount> findUnPushToSAAS();
}
