package com.bcxin.ars.dao.subsidy;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.subsidy.TrainSubsidyConfig;
import com.bcxin.ars.dto.page.TrainSubsidyConfigPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *培训单位补贴简称批次配置Dao
 * @author linqinglin
 * @Date 2020-05-27 10:30:45
 */
public interface TrainSubsidyConfigDao {

   /****
     * 删除
     * @param trainSubsidyConfig
     * @return
     */
    int delete(TrainSubsidyConfig trainSubsidyConfig);

    /****
     * 保存
     * @param trainSubsidyConfig
     * @return
     */
    int save(TrainSubsidyConfig trainSubsidyConfig);

    /****
     * 新增
     * @param trainSubsidyConfig
     * @return
     */
    int insert(TrainSubsidyConfig trainSubsidyConfig);

    /****
     * 主键查询
     * @param id
     * @return
     */
    TrainSubsidyConfig findById(Long id);

    TrainSubsidyConfig findByIdWithOutCache(Long id);

    /****
     * 选择修改
     * @param trainSubsidyConfig
     * @return
     */
    int updateSelective(TrainSubsidyConfig trainSubsidyConfig);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<TrainSubsidyConfig> searchForPage(TrainSubsidyConfigPageSearchDto searchDto, AjaxPageResponse<TrainSubsidyConfig> page);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<TrainSubsidyConfig> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<TrainSubsidyConfig> findByBatchId(@Param("list") List<TrainSubsidyConfig> list);

    List<TrainSubsidyConfig> findByBatchIdWithOutCache(@Param("list") List<TrainSubsidyConfig> list);

    TrainSubsidyConfig findByTrainIdAndSubsidyCerType(@Param("trainId") Long trainId,@Param("subsidyCerType")String subsidyCerType);
}
