package com.bcxin.ars.dao.subsidy;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.subsidy.SubsidyOfflinePageSearchDto;
import com.bcxin.ars.model.subsidy.SubsidyOffline;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 线下补贴审批单Dao接口
 * 
 * @author lin
 * @date 2020-11-12
 */
public interface SubsidyOfflineDao{

    /****
     * 删除
     * @param subsidyOffline
     * @return
     */
    int delete(SubsidyOffline SubsidyOffline);

    /****
     * 保存
     * @param subsidyOffline
     * @return
     */
    int save(SubsidyOffline subsidyOffline);

    /****
     * 主键查询
     * @param id
     * @return
     */
    SubsidyOffline findById(Long id);

    /****
     * 选择修改
     * @param subsidyOffline
     * @return
     */
    int updateSelective(SubsidyOffline subsidyOffline);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<SubsidyOffline> searchForPage(SubsidyOfflinePageSearchDto searchDto, AjaxPageResponse<SubsidyOffline> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<SubsidyOffline> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<SubsidyOffline> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<SubsidyOffline> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<SubsidyOffline> findByBatchId(@Param("list") List<SubsidyOffline> list);


    void releaseBatch(SubsidyOffline subsidyOffline);
}
