package com.bcxin.ars.dao.subsidy;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.subsidy.SubsidyOfflineBatch;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 线下补贴审批单关联批次Dao接口
 * 
 * @author lin
 * @date 2020-11-12
 */
public interface SubsidyOfflineBatchDao{

    /****
     * 删除
     * @param subsidyOfflineBatch
     * @return
     */
    int delete(SubsidyOfflineBatch SubsidyOfflineBatch);

    /****
     * 保存
     * @param subsidyOfflineBatch
     * @return
     */
    int save(SubsidyOfflineBatch subsidyOfflineBatch);

    /****
     * 主键查询
     * @param id
     * @return
     */
        SubsidyOfflineBatch findById(Long id);

    /****
     * 选择修改
     * @param subsidyOfflineBatch
     * @return
     */
    int updateSelective(SubsidyOfflineBatch subsidyOfflineBatch);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<SubsidyOfflineBatch> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<SubsidyOfflineBatch> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<SubsidyOfflineBatch> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<SubsidyOfflineBatch> findByBatchId(@Param("list") List<SubsidyOfflineBatch> list);


}
