package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.report.YearReportDto;
import com.bcxin.ars.dto.report.YearReportsSearchDto;
import com.bcxin.ars.dto.sb.YearReportDataDto;
import com.bcxin.ars.model.sb.Yearreportdata;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface YearreportdataDAO {
    /***
     * 根据用户查询列表
     * @param userId
     * @return
     */
    Yearreportdata findByUserId(long userId,String filingYear);

    /**
     *
     * @Decription:批量查询
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018/8/17 9:17
     * @params： * @param approvalList
     * @return java.util.List<com.bcxin.ars.model.sb.Yearreportdata>
     */
    List<Yearreportdata> findByBatchId(@Param("approvalList") List<Approval> approvalList);

    List<Yearreportdata> findByBatchIdWithOutCache(@Param("approvalList") List<Approval> approvalList);


    /**
     *
     * @Decription:批量更新
     * @author：zhongjianhui
     * @method  updateBatch
     * @date：2018/8/17 9:20
     * @params： * @param approvalList
     * @return void
     */
    void updateBatch(@Param("approvalList")List<Yearreportdata> approvalList);
    /***
     * 保存
     * @param yearreportdata
     */
    Long save(Yearreportdata yearreportdata);

    void update(Yearreportdata yearreportdata);

	Yearreportdata findById(Long businessid);

	Yearreportdata findByIdWithOutCache(Long businessid);

	List<Yearreportdata> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    List<YearReportDto> yearReportSearch(YearReportsSearchDto searchDto);

    Long yearReportSearchCount(YearReportsSearchDto searchDto);

    void updateOperator(Yearreportdata yearreportdata);

	void updateSealState(Yearreportdata dbYearreportdata);

	void updateStatistics(Yearreportdata yearreportdata);

    /***
     * 更新指派民警ID
     * @param yearreportdata
     */
    void updatePoliceId(Yearreportdata yearreportdata);

	List<YearReportDataDto> queryTable(YearReportsSearchDto searchDto);

	Long queryTableCount(YearReportsSearchDto searchDto);

    List<Map<Object,Object>>  searchForPage(YearReportsSearchDto searchDto, AjaxPageResponse<YearReportDto> page);
}