package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.TrainrecordPageSearchDto;
import com.bcxin.ars.model.sb.Trainrecord;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 保安培训单位备案Dao接口
 * 
 * @author lin
 * @date 2022-08-14
 */
public interface TrainrecordDao{

    /****
     * 删除
     * @param trainrecord
     * @return
     */
    int delete(Trainrecord trainrecord);

    /****
     * 保存
     * @param trainrecord
     * @return
     */
    int save(Trainrecord trainrecord);

    /****
     * 主键查询
     * @param id
     * @return
     */
     Trainrecord findById(Long id);

    /****
     * 选择修改
     * @param trainrecord
     * @return
     */
    int updateSelective(Trainrecord trainrecord);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<Trainrecord> searchForPage(TrainrecordPageSearchDto searchDto, AjaxPageResponse<Trainrecord> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<Trainrecord> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<Trainrecord> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<Trainrecord> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<Trainrecord> findByBatchId(@Param("list")List<Trainrecord> list);


    Trainrecord findByUser(Long userid);

    Trainrecord findApproveByCompanyName(String companyname);
}
