package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.certificate.GradeAndCertificateDto;
import com.bcxin.ars.dto.sb.PersonGradeSearchDto;
import com.bcxin.ars.model.sb.PersonGrade;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 *保安员等级证报名Dao
 * @author linqinglin
 * @Date 2020-01-15 20:19:23
 */
public interface PersonGradeDao {

    /****
     * 删除
     * @param personGrade
     * @return
     */
    int delete(PersonGrade personGrade);

    /****
     * 保存
     * @param personGrade
     * @return
     */
    int save(PersonGrade personGrade);

    /****
     * 主键查询
     * @param id
     * @return
     */
    PersonGrade findById(Long id);

    PersonGrade findByIdWithOutCache(Long id);

    /****
     * 修改
     * @param personGrade
     * @return
     */
    int update(PersonGrade personGrade);

    /****
     * 选择修改
     * @param personGrade
     * @return
     */
    int updateSelective(PersonGrade personGrade);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<PersonGrade> searchForPage(PersonGradeSearchDto searchDto, AjaxPageResponse<PersonGrade> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<PersonGrade> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<PersonGrade> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<PersonGrade> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<PersonGrade> findByBatchId(@Param("list")List<PersonGrade> list);

    List<PersonGrade> findByBatchIdWithOutCache(@Param("list")List<PersonGrade> list);

    /**
     * 查询未背景筛查保安员等级证报名记录
     * @return
     */
    List<PersonGrade> findNoCensorStatus();

    /**
     * 批量根据人员id查询报名状态与证书类型
     * @param personIds
     * @return
     */
    List<GradeAndCertificateDto> selectSignUpByIds(@Param("personIds")Long[] personIds);
    List<GradeAndCertificateDto> selectGradeSignUpByIds(@Param("personIds")Long[] personIds);

    int checkPersonGradeCer(PersonGrade personGrade);

    void updatePast(PersonGrade personGrade);

    /**
     * 内到外同步批量保存
     * 内外都存在更新 内网会修改补贴比对状态 背景筛查状态
     * @param list
     */
    void saveBatchForDSIn2Out(List<PersonGrade> list);

    /**
     * 根据classId更新
     *
     * @param personGrade 人员
     */
    void updateByClassId(PersonGrade personGrade);

    /**
     * 第三方培训平台所需背景筛查, 查询筛查状态
     *
     * @param idNumberList 身份证
     * @return 身份证/筛查状态
     */
    List<PersonGrade> findCensorStatusByIdNumbers(@Param("idNumberList") List<String> idNumberList);

    /**
     * 查询申报中/申报成功的身份证列表
     *
     * @param idNumbers 身份证集合
     * @return {@link List<String>}
     */
    List<String> findAppliedByIdNumbers(@Param("idNumbers") Set<String> idNumbers);

    /**
     * 根据身份证查询报名信息
     *
     * @param idNumber 身份证号
     * @return {@link PersonGrade}
     */
    PersonGrade findByIdNumber(String idNumber);

    /**
     * 批量查询
     *
     * @param list
     * @return
     */
    List<PersonGrade> findByBatchIdOnApproval(@Param("list") List<PersonGrade> list);

    List<PersonGrade>  searchForPageBySubsidy(PersonGradeSearchDto searchDto, AjaxPageResponse page);
}
