package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.PerCheckRecordPageSearchDto;
import com.bcxin.ars.model.sb.PerCheckRecord;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 抽查记录Dao接口
 *
 * @author lin
 * @date 2020-12-09
 */
public interface PerCheckRecordDao {

    /****
     * 删除
     * @param perCheckRecord
     * @return
     */
    int delete(PerCheckRecord perCheckRecord);

    /****
     * 保存
     * @param perCheckRecord
     * @return
     */
    int save(PerCheckRecord perCheckRecord);

    /****
     * 主键查询
     * @param id
     * @return
     */
    PerCheckRecord findById(Long id);

    /****
     * 选择修改
     * @param perCheckRecord
     * @return
     */
    int updateSelective(PerCheckRecord perCheckRecord);

    /**
     * 分页查询
     *
     * @param searchDto
     * @param page
     * @return
     */
    List<PerCheckRecord> searchForPage(PerCheckRecordPageSearchDto searchDto, AjaxPageResponse<PerCheckRecord> page);

    /**
     * 外导内查询
     *
     * @param searchDto
     * @return
     */
    List<PerCheckRecord> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     *
     * @param startDate
     * @return
     */
    List<PerCheckRecord> findDSOutList(String startDate);

    /**
     * 批量保存
     *
     * @param list
     */
    void saveBatch(@Param("list") List<PerCheckRecord> list);

    /**
     * 批量查询
     *
     * @param list
     * @return
     */
    List<PerCheckRecord> findByBatchId(@Param("list") List<PerCheckRecord> list);


}
