package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.InvestorPageSearchDto;
import com.bcxin.ars.dto.sb.InvestorDto;
import com.bcxin.ars.dto.sb.InvestorSearchDto;
import com.bcxin.ars.model.sb.Investor;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

public interface InvestorDao {

	Investor findById(long id);


	List<Investor>  findByAll();

	Long saveById(Investor investor);
	
	void update(Investor investor);
	
	List<Investor> search(InvestorSearchDto dto);
	
	Long searchCount(InvestorSearchDto dto);

	void delete(Investor investor);

	List<Investor> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveForDS(Investor investor);

	List<Investor> findByUserId(Long userId);

	/**
	 * 用于股东信息不全发送站内信提醒
	 * @return 所有股东信息
	 */
	List<InvestorDto> listWithComId();

	/**
	 * 分页查询
	 * @param searchDto
	 * @param page
	 * @return
	 */
	List<Investor> searchForPage(InvestorPageSearchDto searchDto, AjaxPageResponse<Investor> page);
}
