package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.GradePracticeSearchDto;
import com.bcxin.ars.model.sb.GradePerson;
import com.bcxin.ars.model.sb.GradePractice;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
/****
 * 等级证实习记录
 * @author  subh
 */
public interface GradePracticeDao {

    /***
     * 保存
     * @param record
     * @return
     */
    int insert(GradePractice record);
    /***
     * 更新
     * @param record
     * @return
     */
    int update(GradePractice record);
    /***
     * 删除
     * @param record
     * @return
     */
    void del(GradePractice record);
    /***
     * 根据ID获取详细
     * @param id 主键
     * @return
     */
    GradePractice findById(Long id);

    /***
     * 等级证实习记录查询
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<GradePractice> query(GradePracticeSearchDto dto, AjaxPageResponse<GradePractice> ajaxPageResponse);
    /***
     * 根据人员ID和等级查询实习天数
     * @param record
     * @return
     */
    Long queryByPersonIdDays(GradePractice record);
    /**
     * 查询需要生成同步文件的等级证实习记录
     * @param dto
     * @return
     */
    List<GradePractice> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 根据personid以及等级搜索实习记录
     * @param personId
     * @param gradeLevel
     * @return
     */
    List<GradePractice> findByPersonIdAndGradeLevel(@Param("personId") Long personId, @Param("gradeLevel") String gradeLevel);
}