package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.FamilySearchDto;
import com.bcxin.ars.model.sb.Family;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface FamilyDao {

	Family findById(long id);
	
	Long save(Family family);

	Long saveForDS(Family family);
	
	void update(Family family);

	List<Family> search(FamilySearchDto dto);

	List<Family> searchByPid(@Param("pid") Long pid);




	Long searchCount(FamilySearchDto dto);

	List<Family> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void delete(Family family);

	Family findByFamily(Family family);

	/**
	 * 通过保安员资格报名id删除家庭成员
	 * @param id 保安员资格报名id
	 */
    void deleteByPersoncertificateId(Long id);
}
