package com.bcxin.ars.dao.sb;


import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.CrosscompanySearchDto;
import com.bcxin.ars.model.sb.Crosscompany;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface CrosscompanyDao {

    Crosscompany findById(Long id);

    Crosscompany findByIdWithOutCache(Long id);
    /**
     *
     * @Decription:批量查询
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018/8/17 9:17
     * @params： * @param approvalList
     * @return java.util.List<com.bcxin.ars.model.sb.Crosscompany>
     */
    List<Crosscompany> findByBatchId(@Param("approvalList") List<Approval> approvalList);

    Long save(Crosscompany crosscompany);

    Long saveForDS(Crosscompany crosscompany);

    void update(Crosscompany crosscompany);
    /**
     *
     * @Decription:批量更新
     * @author：zhongjianhui
     * @method  updateBatch
     * @date：2018/8/17 9:20
     * @params： * @param approvalList
     * @return void
     */
    void updateBatch(@Param("approvalList")List<Crosscompany> approvalList);

    Crosscompany findByUser(Long userid);

    List<Crosscompany> search(CrosscompanySearchDto dto);

    Long searchCount(CrosscompanySearchDto resultDto);

    List<Crosscompany> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	List<Crosscompany> findAll();

	void updateForDS(Crosscompany crosscompany);

    int countCrosscompanyList(Map<Object, Object> p);

    List<Map<Object,Object>>  searchCrosscompanyList(Map<Object, Object> p);

    Crosscompany findApproveByManagerproject(Crosscompany crosscompany);

    /**
     * 根据单据id查询申请人信息
     *
     * @param id
     * @return
     */
    Map<String, Object> selectApplyUserInfoWithId(Long id);

    List<Map<Object, Object>> searchForPage(CrosscompanySearchDto dto, AjaxPageResponse<Crosscompany> page);

    /**
     * 查询备案快过期的公司Id集合
     *
     * @return 公司集合
     */
    List<String> findFilingExpiredIds();

    List<Crosscompany> findUnIntegrated();
}
