package com.bcxin.ars.dao.msg;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.msg.NewsnoticeCompanySearchDto;
import com.bcxin.ars.model.msg.NewsnoticeCompany;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface NewsnoticeCompanyDao {

    void delete(NewsnoticeCompany newsnoticeCompany);

    void recall(NewsnoticeCompany newsnoticeCompany);

    Long save(NewsnoticeCompany newsnoticeCompany);

    NewsnoticeCompany findById(long id);

    void update(NewsnoticeCompany newsnoticeCompany);

    List<NewsnoticeCompany> search(NewsnoticeCompanySearchDto dto);

    Long searchCount(NewsnoticeCompanySearchDto dto);

    int countNewsnoticeCompanyList(Map<Object, Object> p);

    List<Map<Object,Object>> searchNewsnoticeCompanyList(Map<Object, Object> p);


    /***
     * 查询消息回复附件用于公安端
     * @param p
     * @return
     */
    List<Map<Object,Object>>  searchNewsnoticeCompanyReplyList(Map<Object, Object> p);

    /****
     * 统计回复列表个数
     * @param p
     * @return
     */
    int countNewsnoticeCompanyReplyList(Map<Object, Object> p);


    /***
     * 查询消息回复附件用于企业端
     * @param p
     * @return
     */
    List<Map<Object,Object>>  searchNewsnoticeCompanyReplyCompanyList(Map<Object, Object> p);

    /****
     * 统计回复列表个数
     * @param p
     * @return
     */
    int countNewsnoticeCompanyReplyCompanyList(Map<Object, Object> p);
    /**
     * 批量更新已读未读状态
     * @param newIds 消息ID列表
     * @param companyId 公司ID
     */
    void updateReadstateByidArr(@Param("newIds")Long[] newIds, @Param("companyId") Long companyId);

    List<NewsnoticeCompany> findUnread();

    /****
     * 统计未阅读个数
     * @param companyId
     * @return
     */
    int countUnread(@Param("companyId") Long companyId);

    void updateReaded(NewsnoticeCompanySearchDto newsnoticeCompany);

	void deleteByNoticePoliceId(NewsnoticeCompany newsnoticeCompany);

	void recallByNoticePoliceId(NewsnoticeCompany newsnoticeCompany);

    /****
     * 根据消息ID查询发送用户名称
     * @param id
     * @return
     */
    List<NewsnoticeCompany> findByNoticePoliceIdForUser(Long id);


    /****
     * 根据消息ID查询发送公司名称
     * @param id
     * @return
     */
	List<NewsnoticeCompany> findByNoticePoliceId(Long id);
    /**
    * @Author: wangcy
    * @Description:同步
    * @Date: 2018/03/08 0008 15:01
    */
    List<NewsnoticeCompany> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    void updateForDS(NewsnoticeCompany dbnewsnoticeCompany);

    void saveForDS(NewsnoticeCompany dbnewsnoticeCompany);

    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
    List<NewsnoticeCompany> searchFromInToOutForExport(String startDate);

    List<NewsnoticeCompany> searchForPage(NewsnoticeCompanySearchDto dto, AjaxPageResponse<NewsnoticeCompany> page);
}