package com.bcxin.ars.dao.epidemic;

import com.bcxin.ars.dto.epidemic.RiskAreaDto;
import com.bcxin.ars.model.epidemic.RiskArea;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 疫情防控街道信息
 */
public interface RiskAreaDao {

    /**
     * 分页查询
     *
     * @param riskAreaDto
     * @param page
     * @return
     */
    List<RiskArea> search(RiskAreaDto riskAreaDto, AjaxPageResponse<RiskArea> page);
    /**
     * 根据ID获取
     * @param id
     * @return
     */
    RiskArea findById(Long id);
    /***
     * 保存
     * @param riskArea
     */
    void save(RiskArea riskArea);

    /**
     * 查询街道信息
     * @return
     */
    List<RiskArea> findAll();


    /***
     * 保存
     * @param riskAreaList
     */
    void saveBatch(@Param("list")List<RiskArea> riskAreaList);
}
