package com.bcxin.ars.dao.certificate;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.certificate.GradeCompleteCer;
import com.bcxin.ars.dto.page.GradeCompleteCerPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *保安员等级证报名结业证书Dao
 * @author linqinglin
 * @Date 2020-02-04 10:50:12
 */
public interface GradeCompleteCerDao {

   /****
     * 删除
     * @param gradeCompleteCer
     * @return
     */
    int delete(GradeCompleteCer gradeCompleteCer);

    /****
     * 保存
     * @param gradeCompleteCer
     * @return
     */
    int save(GradeCompleteCer gradeCompleteCer);

    /****
     * 新增
     * @param gradeCompleteCer
     * @return
     */
    int insert(GradeCompleteCer gradeCompleteCer);

    /****
     * 选择性插入
     * @param gradeCompleteCer
     * @return
     */
    int insertSelective(GradeCompleteCer gradeCompleteCer);

    /****
     * 主键查询
     * @param id
     * @return
     */
    GradeCompleteCer findById(Long id);

    /****
     * 修改
     * @param gradeCompleteCer
     * @return
     */
    int update(GradeCompleteCer gradeCompleteCer);

    /****
     * 选择修改
     * @param gradeCompleteCer
     * @return
     */
    int updateSelective(GradeCompleteCer gradeCompleteCer);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<GradeCompleteCer> searchForPage(GradeCompleteCerPageSearchDto searchDto, AjaxPageResponse<GradeCompleteCer> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<GradeCompleteCer> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<GradeCompleteCer> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<GradeCompleteCer> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<GradeCompleteCer> findByBatchId(@Param("list") List<GradeCompleteCer> list);

    /**
     * 根据报名id查询证书
     * @param personGradeId
     * @return
     */
    GradeCompleteCer findByPersonGradeId(Long personGradeId);

    /**
     * 根据身份证号 查询证书
     * @param idNum
     * @param gradeLevel
     * @return
     */
    GradeCompleteCer findByIdNum(@Param("idNum") String idNum,@Param("gradeLevel")String gradeLevel);

    String getNextVal(String seqCompleteCer);
}
