package com.bcxin.ars.dao.approve;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.approve.ApproveTempLinkRelaDto;
import com.bcxin.ars.dto.approve.CheckTempConfigDto;
import com.bcxin.ars.model.approve.ApproveTempLinkRela;

import java.util.List;

/**
 * 审批模板环节关联
 * 
 * @author zhangye
 * @version 1.0
 */
public interface ApproveTempLinkRelaDao {

	/**
	 * 根据模板ID获取已经配置的模板环节列表
	 *
	 * @return
	 */
	List<ApproveTempLinkRela> findByApproveTempIdList(Long approveTempId);

	/**
	 * 根据模板ID获取未配置的模板环节列表
	 *
	 * @return
	 */
	List<ApproveTempLinkRela> findNotConfigByApproveTempIdList(Long approveTempId);

	/**
	 * 根据模板ID检查审批模板环节是否都配置完成
	 *
	 * @return
	 */
	Long checkTempConfigComplete(Long approveTempId);

	/**
	 * @Author: wangcy
	 * @Description:根据ID查询
	 * @Date: 2018/02/03 0003 17:06
	 */
	ApproveTempLinkRela findById(Long id);

	/**
	 * @Author: wangcy
	 * @Description:修改
	 * @Date: 2018/02/03 0003 17:10
	 */
	void update(ApproveTempLinkRela approveTempLinkRela);

	/**
	 * @Author: wangcy
	 * @Description:查询Dto
	 * @Date: 2018/02/03 0003 17:10
	 */
	ApproveTempLinkRelaDto findDtoById(Long tempLinkRelaId);

	/**
	 * @Author: wangcy
	 * @Description:查询所有
	 * @Date: 2018/02/23 0023 16:56
	 */
	List<ApproveTempLinkRela> findAll();

	/**
	 * @Author: wangcy
	 * @Description:批量插入临时表数据
	 * @Date: 2018/01/19 0019 15:31
	 */
	void insertBatchTemp(List<ApproveTempLinkRela> approveList);

	void updateFlagForOutToIn(List<ApproveTempLinkRela> approveList);

	/**
	 * 
	 * @param checkDto
	 * @return
	 */
	Long checkTempConfigCompleteByOrgTypeAndCityCode(CheckTempConfigDto checkDto);

	/**
	 * 根据模板ID、环节ID获取有效的模板环节关联信息
	 * 
	 * @param linkId
	 * @param tempId
	 * @return
	 */
	ApproveTempLinkRela findByActiveTempAndLink(Long linkId, Long tempId);

	/**
	 * 根据模板ID、机构类型、机构地区获取模板环节数量
	 * 
	 * @param checkDto
	 * @return
	 */
	Long getTempLinkByPoliceCount(CheckTempConfigDto checkDto);

	/**
	 * 检查当前登陆机构是否都配置好并启动环节
	 * @param checkDto
	 * @return
	 */
	Long checkTempConfigCompleteByOrgId(CheckTempConfigDto checkDto);

	/**
	 * 内导外查询
	 * @return
	 */
	List<ApproveTempLinkRela> searchFromInToOutForExport();

	/**
	 * 外导内查询
	 * @param searchDto
	 * @return
	 */
	List<ApproveTempLinkRela> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);
}
