package com.bcxin.ars.dao.approve;

import java.util.List;

import com.bcxin.ars.dto.approve.ApproveLinkProDetailDto;
import com.bcxin.ars.dto.approve.ApproveTempLinkDto;
import com.bcxin.ars.model.approve.ApproveLinkProDetail;
import com.bcxin.ars.model.approve.ApproveTempLink;

/**
 * @author：wangcy @date：2018/01/25 0025 15:16
 * @description：审批环节流程明细Dao
 */
public interface ApproveLinkProDetailDao {

	/**
	 * @Author: wangcy
	 * @Description:批量新增
	 * @Date: 2018/01/25 0025 15:39
	 */
	void batchSave(List<ApproveLinkProDetail> approveLinkProDetailList);

	/**
	 * @Author: wangcy
	 * @Description:通过ID查询
	 * @Date: 2018/01/25 0025 15:39
	 */
	ApproveLinkProDetail findById(Long approveLinkProDetailId);

	/**
	 * @Author: wangcy
	 * @Description:批量修改
	 * @Date: 2018/01/25 0025 15:39
	 */
	void batchUpdate(List<ApproveLinkProDetail> approveLinkProDetailListUpdate);

	/**
	 * @Author: wangcy
	 * @Description:新增
	 * @Date: 2018/01/25 0025 15:39
	 */
	void save(ApproveLinkProDetail approveLinkProDetail);

	/**
	 * @Author: wangcy
	 * @Description:新增
	 * @Date: 2018/01/25 0025 15:39
	 */
	void update(ApproveLinkProDetail approveLinkProDetail);

	/**
	 * @Author: wangcy
	 * @Description:条件查询
	 * @Date: 2018/01/25 0025 15:39
	 */
	ApproveLinkProDetail findByPoliceId(Long id, Long tempLinkRelaId);

	/**
	 * @Author: wangcy
	 * @Description:删除相关的审批环节流程明细
	 * @Date: 2018/02/02 0002 10:04
	 */
	void deleteByApproveTempLinkId(ApproveTempLink approveTempLink);

	/**
	 * @Author: zhangye
	 * @Description:根据审批模板环节关联ID、单位代码获取审批环节流程明细(一级子流程)
	 * @Date: 2018/01/25 0025 15:39
	 */
	ApproveLinkProDetail findListByTempLinkRelaIdAndPoliceCode(Long tempLinkRelaId, String policeCode);

	/**
	 * @Author: wangcy
	 * @Description:关联ID查询
	 * @Date: 2018/02/03 0003 16:53
	 */
	List<ApproveLinkProDetail> findByTempLinkRelaId(Long tempLinkRelaId);

	void deleteByApproveTempLinkIdAndPoliceId(ApproveTempLinkDto approveTempLink);

	ApproveLinkProDetail findListByTempLinkRelaIdAndPoliceIds(ApproveLinkProDetailDto searchDto);

    List<ApproveLinkProDetail> findListByTempId(Long tempId);
}
