package com.bcxin.ars.dao.approve;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.approve.ApproveLinkLevel;

import java.util.List;

/**
 * @author：wangcy @date：2018/01/19 0019 14:57
 * @description：审批环节层级
 */
public interface ApproveLinkLevelDao {
	/**
	 * @Author: wangcy
	 * @Description:查询属于这个环节的层级（List）
	 * @Date: 2018/01/19 0019 15:31
	 */
	List<ApproveLinkLevel> findListByTempLinkRelaId(Long tempLinkRelaId);

	/**
	 * @Author: wangcy
	 * @Description:通过ID查询
	 * @Date: 2018/01/19 0019 15:31
	 */
	ApproveLinkLevel findById(Long id);

	/**
	 * @Author: wangcy
	 * @Description:删除
	 * @Date: 2018/01/19 0019 15:31
	 */

	void delete(ApproveLinkLevel approveLinkLevel);

	/**
	 * @Author: wangcy
	 * @Description:查询属于这个环节所有的层级（List）
	 * @Date: 2018/01/19 0019 15:31
	 */
	List<ApproveLinkLevel> findListByAllApproveLinkId(Long approveLinkId);

	/**
	 * @Author: wangcy
	 * @Description:修改
	 * @Date: 2018/01/19 0019 15:31
	 */
	void update(ApproveLinkLevel approveLinkLevel);

	/**
	 * @Author: wangcy
	 * @Description:新建
	 * @Date: 2018/01/19 0019 15:31
	 */
	Long save(ApproveLinkLevel approveLinkLevel);

	/**
	 * @Author: wangcy
	 * @Description:将下属所有配置清空
	 * @Date: 2018/01/24 0024 11:12
	 */
	void deleteSubordinate(String areacode, String userName, Long approveLinkId);

	/**
	 * @Author: wangcy
	 * @Description:将审批环节流程明细配置清空
	 * @Date: 2018/01/24 0024 11:12
	 */
	void deleteApproveDetail(String substring, String name, Long approveLinkId);

	/**
	 * @Author: wangcy
	 * @Description:查询属于这个环节所有的层级（List）启动的
	 * @Date: 2018/01/19 0019 15:31
	 */
	List<ApproveLinkLevel> findListTureByAllApproveLinkId(Long tempLinkRelaId);

	/**
	 * @Author: wangcy
	 * @Description:查询属于这个环节指定的层级（List）启动的
	 * @Date: 2018/01/19 0019 15:31
	 */
	List<ApproveLinkLevel> findListTureByApproveLinkIdAndLevel(Long tempLinkRelaId, String approveLevel);

	/**
	 * @Author: zhangye
	 * @Description:根据审批模板环节关联ID返回最大审批环节层级
	 * @Date: 2018/01/19 0019 15:31
	 */
	String getMaxApproveLevelByTempLinkRelaId(Long tempLinkRelaId);

	/**
	* @Author: wangcy
	* @Description:查询全部
	* @Date: 2018/02/23 0023 16:53
	*/
    List<ApproveLinkLevel> findAll();
    
	/**
     * @Author: wangcy
     * @Description:批量插入临时表数据
     * @Date: 2018/01/19 0019 15:31
     */
	void insertBatchTemp(List<ApproveLinkLevel> approveList);

	void updateFlagForOutToIn(List<ApproveLinkLevel> approveList);

	List<ApproveLinkLevel> searchFromInToOutForExport();

	List<ApproveLinkLevel> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);
}
