package com.bcxin.ars.dao.approve;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.approve.ApproveAreaProcessDto;
import com.bcxin.ars.dto.approve.ApproveOrgDto;
import com.bcxin.ars.dto.approve.ApproveProcessDto;
import com.bcxin.ars.dto.approve.ApproveTempOrgDto;
import com.bcxin.ars.model.approve.ApproveAreaProcess;
import com.bcxin.ars.model.approve.ApproveTempLink;

import java.util.List;

/**
 * @author：wangcy
 * @date：2018/01/22 0022 13:35
 * @description：区域审批流程dao
 */
public interface ApproveAreaProcessDao {

    /**
     * @Author: wangcy
     * @Description:根据条件查询
     * @Date: 2018/01/19 0019 15:31
     */
    List<ApproveAreaProcessDto> search(ApproveAreaProcessDto ApproveAreaProcessDto);
    /**
     * @Author: wangcy
     * @Description:根据条件查询
     * @Date: 2018/01/19 0019 15:31
     */
    List<ApproveAreaProcessDto> searchProcess();

    /**
     * @Author: wangcy
     * @Description:根据单位所在区域ID和审批环节层级ID查询
     * @Date: 2018/01/19 0019 15:31
     */
    ApproveAreaProcess findByLinkLevelIdAndUnitid(ApproveAreaProcess approveAreaProcess);

    /**
    * @Author: wangcy
    * @Description:新建
    * @Date: 2018/01/22 0022 17:04
    */
    Long save(ApproveAreaProcess approveAreaProcess);

    /**
     * @Author: wangcy
     * @Description:创建该地区下的所有的派出所的区域审批流程，状态为失效
     * @Date: 2018/01/23 0023 17:13
     */
    void saveAreaProcessByAreacodeFailure(String substring, Long id, String approveLevel);

    /**
     * @Author: wangcy
     * @Description:创建该地区下的所有的派出所的区域审批流程，状态为失效
     * @Date: 2018/01/23 0023 17:13
     */
    void updateAreaProcessByAreacode(String substring, Long id, String approveLevel);

    /**
     * @Author: wangcy
     * @Description:创建该地区下的所有的派出所的区域审批流程，状态为失效
     * @Date: 2018/01/23 0023 17:13
     */
    void updateAreaProcessByAreacodeFailure(String substring, Long id, String approveLevel);
    /**
     * @Author: wangcy
     * @Description:修改
     * @Date: 2018/01/23 0023 17:13
     */
    void update(ApproveAreaProcess approveAreaProcessdb);

    /**
    * @Author: wangcy
    * @Description:根据公安ID判断流程线是否完成
    * @Date: 2018/01/25 0025 13:44
    */
    List<ApproveProcessDto> findApproveListByPoliceId(Long id,Long approveLinkLevelId);
    /**
     * @Author: wangcy
     * @Description:根据公安ID判断流程线那些已经完成了
     * @Date: 2018/01/25 0025 13:44
     */
    List<ApproveProcessDto> findApproveListByPoliceIdEXISTS(Long id,Long approveLinkLevelId);

    /**
     * @Author: wangcy
     * @Description:根据Id 查询
     * @Date: 2018/01/19 0019 15:31
     */
    ApproveAreaProcess findById (Long Id);

    /**
     * @Author: wangcy
     * @Description:根据公安ID查询已完成的流程
     * @Date: 2018/01/19 0019 15:31
     */
    List<ApproveProcessDto> findAllIdBypolice(Long id, Long tempLinkRelaId);

	List<ApproveOrgDto> findApproveOrgList(ApproveAreaProcessDto approveAreaProcess);

    /**
     * 根据机构id查询列表
     * @param approveAreaProcess
     * @return
     */
    List<ApproveOrgDto> findApproveOrgListBypoliceId(ApproveAreaProcessDto approveAreaProcess);
    /**
    * @Author: wangcy
    * @Description://2.删除相关的审批环节层级 及区域审批流程
    * @Date: 2018/02/02 0002 9:55
    */
    void deleteByApproveTempLinkId(ApproveTempLink approveTempLink);
    /**
     * @Author: wangcy
     * @Description:关联ID查询
     * @Date: 2018/02/03 0003 16:53
     */
    List<ApproveAreaProcess> findByTempLinkRelaId(Long tempLinkRelaId);
    
    /**
     * 
     * @Description:根据tempCode,policeId查询配置数量
     * @param approveTempOrgDto
     * @return Long
     * @author LinQingLin 
     * @date 2018年2月23日 上午10:27:58
     * @注意事项 </b>
     * <b>
     */
    Long getCountByTempCodeAndPoliceId(ApproveTempOrgDto approveTempOrgDto);

    /**
       * @Author: wangcy
       * @Description:查询所有
       * @Date: 2018/02/03 0003 16:53
    */
    List<ApproveAreaProcess> findAll();

    void insertBatchTemp(List<ApproveAreaProcess> list);

    void updateFlagForOutToIn(List<ApproveAreaProcess> list);

	ApproveAreaProcess findByLinkLevelIdAndPoliceId(Long approveLinkLevelId, Long policeId);

    List<ApproveAreaProcess> searchFromInToOutForExport();

    List<ApproveAreaProcess> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);
}
