package com.bcxin.ars.dao;


import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SecurityGoodThingDetailDTO;
import com.bcxin.ars.dto.SecurityGoodThingDto;
import com.bcxin.ars.model.SbPunish;
import com.bcxin.ars.model.SecurityGoodThing;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/5/18.
 */
public interface SecurityGoodThingDao {

    void save(SecurityGoodThing securityGoodThing);

    public List<SecurityGoodThing> findByUserid(Long userid);

    public SecurityGoodThing findById(Long id);

    public List<SecurityGoodThing> search(SecurityGoodThingDto dto);

    Long searchCount(SecurityGoodThingDto dto);

    public SecurityGoodThing updateById(SecurityGoodThing securityGoodThing);

    void delete(SecurityGoodThing securityGoodThing);

    void deleteByUserid(SecurityGoodThing securityGoodThing);

	List<SecurityGoodThing> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveForDS(SecurityGoodThing securityGoodThing);

	SecurityGoodThingDetailDTO findByIdForPerson(Long id);

    /**
     * 好人好事查询 wjb 2018年11月13日13:38:00
     * @param p
     * @return
     */
    int countSecuritygoodthingList(Map<Object, Object> p);

    List<Map<Object,Object>>  searchSecuritygoodthingList(Map<Object, Object> p);

    /**
     * 与saas对接 根据saas主键删除
     * @param goodDeedsId
     * @return
     */
    void deleteGoodThingByGoodDeedsId(Long goodDeedsId);

    /**
     * 与saas对接 根据saas主键查询
     * @param id
     * @return
     */
    SecurityGoodThing findByGoodDeedsId(Long id);

    /**
     * 与saas对接 根据saas主键更新
     * @param dbSecurityGoodThing
     * @return
     */
    void updateByGoodDeedsId(SecurityGoodThing dbSecurityGoodThing);


    /**
     * 根据身份证查询
     * @param idNum
     * @return
     */
    List<SecurityGoodThing> findByIdNum(String idNum);


    /***
     * 查询好人好事
     * @param dto 查询条件参数
     * @return 查询列表
     */
    List<SecurityGoodThing> query(SecurityGoodThingDto dto, AjaxPageResponse<SecurityGoodThing> ajaxPageResponse);
}
