package com.bcxin.ars.dao;

import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.page.CompanyDto;
import com.bcxin.ars.dto.page.CompanyPageSearchDto;
import com.bcxin.ars.dto.report.*;
import com.bcxin.ars.model.SecurityCompany;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface SecurityCompanyDao  {




	//查询保全list数据
	List<Map<Object,Object>> querySercurityCompanyList(Map<Object, Object> p);
	/**
	 *
	 * @Decription: 查询公司总数，初始化数
	 * @author：zhongjianhui
	 * @method  queryCompanyStatistics
	 * @date：2018/5/29 14:04
	 * @params： * @param p
	 * @return java.util.Map
	 */
	Map queryCompanyStatistics(Map<Object, Object> p);

	int queryAllCnt(Map<Object, Object> p);

	int queryInitCnt(Map<Object, Object> p);

	int queryNotInitCnt(Map<Object, Object> p);

	int queryNewAddCnt(Map<Object, Object> p);

	SecurityCompany queryCompanyDetail( Long id);


	SecurityCompany findById(Long id);

	SecurityCompany findByIdWithOutCache(Long id);
	/**
	 *
	 * @Decription:查询保安员证数量
	 * @author：zhongjianhui
	 * @method  countForCertifity
	 * @date：2018/11/13 17:19
	 * @params： * @param id
	 * @return int
	 */
	int countForCertifity(Long id);
	/**
	 *
	 * @Decription:查询保安员数量
	 * @author：zhongjianhui
	 * @method  countForCertifity
	 * @date：2018/11/13 17:19
	 * @params： * @param id
	 * @return int
	 */
	int countForSecurityPerson(Long id);

	List<SecurityCompany> findByAll(@Param("institutionType") String type);

	/**
	 * 查找需要可以补证的公司
	 * @param type
	 * @return
	 */
	List<SecurityCompany> findByAllExceptHaveCer(String type);

	/***
     * 查询公司数据为了部级上报
     * @param type 类型
     * @return
     */
    List<SecurityCompany> findByAllForBj(@Param("institutionType") String type);

	SecurityCompany findByUserid(Long userid);

	SecurityCompany findByUserName(String userName);

	SecurityCompany findBySocialCode(String socialCode);
	
	List<SecurityCompany> search(CompanySearchDto dto);

	List<SecurityCompany> searchForDataSynchronization(DataSynchronizationSearchDto dto);
	
	Long searchCount(CompanySearchDto dto);
	
	List<PersonStudyDTO> findPersonStudyList(PersonStudySearchDTO dto);
	
	Long searchPersonStudyCount(PersonStudySearchDTO dto);
	
	Long save(SecurityCompany company);
	
	void update(SecurityCompany company);

	List<ReportData> findAllAreaReport(CompanySearchDto dto);
	
	List<ReportData> findAllScaleReport(CompanySearchDto dto);
	
	List<ReportData> findAllTaskLevelReport(CompanySearchDto dto);

	List<ReportData> findProfessionLevelReport(Long id);
	
	List<ReportData> findSecurityPersonReport(CompanySearchDto dto);

	List<ReportData> findNativeReport(Long id);
	
	List<ReportData> findTaskCatalogReport(Long id);
	
	List<ReportData> findTaskLevelReport(Long id);
	
	List<ReportData> getStudyListDesc(Long id);
	
	List<ReportData> findSecurityPersonStudyReport(Long id);
	
	Long findNoPowerCount (Long id);
	
	Long getSecurityTotalCount(Long id);

	void delete(SecurityCompany company);

	List<SecurityCompany> searchForManager(CompanySearchDto dto);

	Long searchForManagerCount(CompanySearchDto dto);
	/**
	 *
	 * @Decription:
	 * @author：zhongjianhui
	 * @method  countSearchForManagerList_table
	 * @date：2018/9/27 10:22
	 * @params： * @param map
	 * @return java.lang.Long
	 */
	Integer countSearchForManagerList_table(Map<Object, Object> p);
	/**
	 *
	 * @Decription:
	 * @author：zhongjianhui
	 * @method  searchForManagerList_table
	 * @date：2018/9/27 10:23
	 * @params： * @param p
	 * @return java.util.List<java.util.Map<java.lang.Object,java.lang.Object>>
	 */
	List<Map<Object,Object>> searchForManagerList_table(Map<Object, Object> p);

	SecurityCompany findByName(String name);

	SecurityCompany findByRawId(Long rawid);

	SecurityCompany findByInRawId(Long inrawid);

	List<SecurityCompany> searchForExportData(CompanySearchDto dto);

	CompanyReportData dataStatisticsInitReport(ReportDataSearchDto searchDto);
	
	List<ReportData> dataStatisticsAddReport(ReportDataSearchDto searchDto);

	List<SupervisionDto> supervisionSearch(SupervisionSearchDto searchDto);
	
	Long supervisionSearchCount(SupervisionSearchDto searchDto);
	
	Long dataStatisticsPersonTotalReport(SupervisionSearchDto searchDto);
	
	Long dataStatisticsPolicyReport(SupervisionSearchDto searchDto);
	
	Long dataStatisticsInitTotalReport(SupervisionSearchDto searchDto);

	TestTrainDto dataStatisticsTestTrainReport(Long companyId);
	
	Long getNoCertificateCount(Long companyId);

	void updateOperatorphone(SecurityCompany securityCompany);

    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
	List<SecurityCompany> searchForExport(String startDate);

	void updateExportFlag(SecurityCompany securityCompany);

	List<ZTree> getCompanyTree(CompanySearchDto searchDto);

	List<ReportData> findTaskLevelReportByCompany(CompanySearchDto company);


	/**
	 * 批量插入人员导入临时表
	 * by llc 2018-08-20
	 * @param list
	 */
	void insertTmpBatchImportPerson(@Param("list") List<Map<String,String>> list, @Param("batchId") int batchId);

	/**
	 * 人员导入存储过程
	 * by llc 2018-08-20
	 * @param paramMap
	 */
	Map<String,Object> prc_batchImportPerson(Map<String,Object> paramMap);

	/**
	 * 查询本次导入的校验失败信息 by llc 2018-08-24
	 *
	 * @param batchId
	 */
	List<Map<String, String>> getFailList(int batchId);

	/**
	 * 删除本次导入的人员信息 by llc 2018-08-24
	 *
	 * @param batchId
	 */
	void deleteTmpBatchImportPerson(int batchId);

	/**
	 * 查询本次导入的成功手机信息 by llc 2018-08-27
	 *
	 * @param batchId
	 */
	List<Map<String,Object>> getSuccessList(int batchId);

	/**
	 * 通过主键id批量查询
	 * @param list
	 * @return
	 */
	List<SecurityCompany> findByBatchId(@Param("list")List<SecurityCompany> list);

	List<SecurityCompany> findByBatchIdWithOutCache(@Param("list")List<SecurityCompany> list);

	/**
	 * @Decription:批量保存
	 * @param list
	 */
	void saveBatch(@Param("list")List<SecurityCompany> list);

	/**
	 * 公司分页查询
	 * @param dto
	 * @param page
	 */
    List<CompanyDto> searchForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page);
	List<CompanyDto> searchForPageV2(CompanyPageSearchDto dto);
    int searchForPageV2Count(CompanyPageSearchDto dto);
    /**
     * 公司分页查询用于预警
     * @param dto
     * @param page
     */
    List<CompanyDto> situationForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page);

    /****
     * 查询异常数据投资人
     * @return 列表
     */
    List<SecurityCompany> findExceptionDataForINVESTOR();

	List<SaaSCompany> findUserNameByBatchId(List<Long> list);

    void updateCertificatesPhoto(List<SecurityCompany> companys);

	/***
	 * 查询最大的公司编号
	 * @return 公司编号
	 */
	String searchMaxCompanyCode(@Param("prefix")String prefix);

    /***
     * 根据公安服务安全平台ComId获取单位信息
     * @param comId
     * @return
     */
    SecurityCompany findByComId(Long comId);
	/***
	 * 根据任务ID获取公司信息
	 * @param comId
	 * @return
	 */
	SecurityCompany findByComTaskId(Long comId);

	/**
	 *自招单位分页查询（兼容旧数据）
	 * @param dto
	 * @param page
	 */
	List<CompanyDto> searchConfessComForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page);

	List<SecurityCompany> findSubCompany(String parentId);

	/**
	 * 查询培训公司的名称
	 * @param institutionType
	 * @return
	 */
    List<String> selectCompanyName(String institutionType);

	/**
	 * 根据sass的comId和userId更新在职保安员数量
	 * @param securityPersonDTO
	 */
	void updateNumber(SecurityPersonDTO securityPersonDTO);

    /**
     * 根据sass的comId和userId更新在职保安员数量
     */
    void updateNumberByTime();

	List<CompanyDto> publicSearchForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page);

    void revoke(SecurityCompany company);

    List<SecurityCompany> findByErrorCompanyCode();
}
