package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbBusinessManagementSearchDto;
import com.bcxin.ars.dto.sb.SbBusinessOutsideManagementSearchDto;
import com.bcxin.ars.model.SbBusinessManagement;
import com.bcxin.ars.model.SbBusinessOutsideManagement;

import java.util.List;

public interface SbBusinessManagementDao {
	/**
	 * 查询
	 * @param sbBusinessManagementSearchDto
	 * @return
	 */
	List<SbBusinessManagement> search(SbBusinessManagementSearchDto sbBusinessManagementSearchDto);

	/**
	 * 保存
	 * @param sbBusinessManagement
	 * @return
	 */
	Long save(SbBusinessManagement sbBusinessManagement);
	/**
	 * 保存
	 * @param sbBusinessManagement
	 * @return
	 */
	Long saveById(SbBusinessManagement sbBusinessManagement);

	/**
	 * 删除
	 * @param sbBusinessManagement
	 * @return
	 */
	Long delete(SbBusinessManagement sbBusinessManagement);

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	SbBusinessManagement findById(Long id);

	/**
	 * 统计
	 * @return
	 */
	long count(SbBusinessManagementSearchDto sbBusinessManagementSearchDto);

	/**
	 * 海外经营信息管理
	 * @param sbBusinessManagement
	 */
	void update(SbBusinessManagement sbBusinessManagement);

	List<SbBusinessManagement> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveForDS(SbBusinessManagement sbBusinessManagement);


}
