package com.bcxin.ars.dao;

import java.util.List;
import com.bcxin.ars.model.EnrolmentLeaveBeijing;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.EnrolmentLeaveBeijingSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

/**
 * 保安员离京登记Dao接口
 *
 * @author zyt
 * @date 2021-02-01
 */
public interface EnrolmentLeaveBeijingDao{

    /****
     * 删除
     * @param enrolmentLeaveBeijing
     * @return
     */
    int delete(EnrolmentLeaveBeijing enrolmentLeaveBeijing);

    /****
     * 保存
     * @param enrolmentLeaveBeijing
     * @return
     */
    int save(EnrolmentLeaveBeijing enrolmentLeaveBeijing);

    /****
     * 主键查询
     * @param id
     * @return
     */
    EnrolmentLeaveBeijing findById(Long id);

    /****
     * 选择修改
     * @param enrolmentLeaveBeijing
     * @return
     */
    int updateSelective(EnrolmentLeaveBeijing enrolmentLeaveBeijing);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<EnrolmentLeaveBeijing> searchForPage(EnrolmentLeaveBeijingSearchDto searchDto, AjaxPageResponse<EnrolmentLeaveBeijing> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<EnrolmentLeaveBeijing> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<EnrolmentLeaveBeijing> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<EnrolmentLeaveBeijing> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<EnrolmentLeaveBeijing> findByBatchId(@Param("list")List<EnrolmentLeaveBeijing> list);


}
