package com.bcxin.ars.dao;

import com.bcxin.ars.dto.page.ConfigPageSearchDto;
import com.bcxin.ars.model.Config;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

/**
 * 配置数据访问类
 * @author Ethan
 */
public interface ConfigDao {

	/**
	 * 获取所有配置
	 * @return
	 */
	List<Config> findAll();

	/**
	 * 获取所有处理签配置表
	 * @return
	 */
	List<Map> findAllConfigSign();
	
	/**
	 * 根据key获取指定配置
	 * @param key
	 * @return
	 */
	Config findByKey(String key);
	/***
	 * 更新
	 * @param config
	 * @return
	 */
	void update(Config config);


	Config findByKeyAndName(String key, String name);


	/**
	 * 根据key模糊查询
	 * @param key
	 * @return
	 */
	List<Config> findByLikeKey(String key);

	/****
	 * 删除
	 * @param config
	 * @return
	 */
	void delete(Config config);

	/**
	 * 新增
	 * @param config
	 */
    void save(Config config);

	/****
	 * 主键查询
	 * @param id
	 * @return
	 */
	Config findById(Long id);


	/****
	 * 选择修改
	 * @param config
	 * @return
	 */
	int updateSelective(Config config);

	/**
	 * 分页查询
	 * @param searchDto
	 * @param page
	 * @return
	 */
	List<Config> searchForPage(ConfigPageSearchDto searchDto, AjaxPageResponse<Config> page);

    void use(Config config);
}
