/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.utils;

import com.bcxin.risk.hibernateplus.utils.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;

public class TypeConvert {
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    public static Long toLong(Object obj) {
        return TypeConvert.toLong(obj, null);
    }

    public static Long toLong(Object obj, Long defaults) {
        if (obj == null) {
            return defaults;
        }
        if (obj.getClass() == Timestamp.class) {
            return ((Timestamp)obj).getTime();
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(obj.toString().trim());
        }
        catch (Exception e) {
            return defaults;
        }
    }

    public static long tolong(Object obj) {
        return TypeConvert.toLong(obj, 0L);
    }

    public static Double toDouble(Object obj) {
        return TypeConvert.toDouble(obj, null);
    }

    public static Double toDouble(Object obj, Double defaults) {
        return obj == null ? defaults : Double.parseDouble(obj.toString());
    }

    public static double todouble(Object obj) {
        return TypeConvert.toDouble(obj, 0.0);
    }

    public static BigDecimal toBigDecimal(Object obj) {
        return TypeConvert.toBigDecimal(obj, BigDecimal.ZERO);
    }

    public static BigDecimal toBigDecimal(Object obj, BigDecimal defaults) {
        return "".equals(StringUtils.toString(obj)) ? defaults : new BigDecimal(obj.toString());
    }

    public static int toInt(Object obj) {
        return TypeConvert.toInteger(obj, 0);
    }

    public static Integer toInteger(Object obj) {
        return TypeConvert.toInteger(obj, null);
    }

    public static Integer toInteger(Object obj, Integer defaults) {
        if (obj == null) {
            return defaults;
        }
        if (obj.toString().length() == 0) {
            return defaults;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            return Integer.valueOf(obj.toString().trim());
        }
        catch (Exception e) {
            return defaults;
        }
    }

    public static String toBoolean(boolean bo) {
        return bo ? TRUE : FALSE;
    }

    public static boolean toBoolean(String bo) {
        return TRUE.equals(bo);
    }

    public static String toString(Object obj) {
        return TypeConvert.toString(obj, "");
    }

    public static String toString(Object obj, String defaults) {
        return StringUtils.toString(obj, defaults);
    }
}

