/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.utils;

import com.bcxin.risk.hibernateplus.condition.DeleteWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.UpdateWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.entity.Convert;
import com.bcxin.risk.hibernateplus.entity.EntityInfo;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.hibernateplus.entity.page.Pagination;
import com.bcxin.risk.hibernateplus.exceptions.HibernatePlusException;
import com.bcxin.risk.hibernateplus.utils.Assert;
import com.bcxin.risk.hibernateplus.utils.CollectionUtils;
import com.bcxin.risk.hibernateplus.utils.EntityInfoUtils;
import com.bcxin.risk.hibernateplus.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.hibernate.engine.jdbc.internal.BasicFormatterImpl;

public class SqlUtils {
    private static final BasicFormatterImpl sqlFormatter = new BasicFormatterImpl();
    private static final String SQL_COUNT = "SELECT COUNT(0) FROM %s %s";
    private static final String SQL_BASE_COUNT = "SELECT COUNT(0) FROM ( %s ) TOTAL";
    private static final String SQL_LIST = "SELECT %s FROM %s %s";
    private static final String SQL_DELETE = "DELETE FROM %s %s";
    private static final String SQL_UPDATE = "UPDATE %s SET %s %s";
    private static List<SelectItem> countSelectItem = null;

    public static String sqlCountOptimize(String originalSql) {
        String sqlCount;
        Assert.hasLength(originalSql);
        try {
            Select selectStatement = (Select)CCJSqlParserUtil.parse((String)originalSql);
            PlainSelect plainSelect = (PlainSelect)selectStatement.getSelectBody();
            Distinct distinct = plainSelect.getDistinct();
            List groupBy = plainSelect.getGroupByColumnReferences();
            List orderBy = plainSelect.getOrderByElements();
            if (CollectionUtils.isEmpty(groupBy) && CollectionUtils.isNotEmpty(orderBy)) {
                plainSelect.setOrderByElements(null);
            }
            if (distinct != null || CollectionUtils.isNotEmpty(groupBy)) {
                return String.format(SQL_BASE_COUNT, selectStatement.toString());
            }
            List<SelectItem> selectCount = SqlUtils.countSelectItem();
            plainSelect.setSelectItems(selectCount);
            sqlCount = selectStatement.toString();
        }
        catch (Exception e) {
            sqlCount = String.format(SQL_BASE_COUNT, originalSql);
        }
        return sqlCount;
    }

    private static List<SelectItem> countSelectItem() {
        if (CollectionUtils.isNotEmpty(countSelectItem)) {
            return countSelectItem;
        }
        Function function = new Function();
        function.setName("COUNT");
        ArrayList<LongValue> expressions = new ArrayList<LongValue>();
        LongValue longValue = new LongValue(0L);
        ExpressionList expressionList = new ExpressionList();
        expressions.add(longValue);
        expressionList.setExpressions(expressions);
        function.setParameters(expressionList);
        countSelectItem = new ArrayList<SelectItem>();
        SelectExpressionItem selectExpressionItem = new SelectExpressionItem((Expression)function);
        countSelectItem.add((SelectItem)selectExpressionItem);
        return countSelectItem;
    }

    public static String concatOrderBy(String originalSql, Pagination page) {
        if (StringUtils.isNotBlank(page.getOrderByField())) {
            StringBuilder buildSql = new StringBuilder(originalSql);
            buildSql.append(" ORDER BY ").append(page.getOrderByField());
            buildSql.append(page.isAsc() ? " ASC " : " DESC ");
            return buildSql.toString();
        }
        return originalSql;
    }

    public static String sqlFormat(String boundSql, boolean format) {
        if (format) {
            return sqlFormatter.format(boundSql);
        }
        return boundSql.replaceAll("[\\s]+", " ");
    }

    public static String sqlEntityList(Class clazz, Wrapper wrapper, Page page) {
        return SqlUtils.sqlList(clazz, true, wrapper, page);
    }

    public static String sqlList(Class clazz, boolean isMapping, Wrapper wrapper, Page page) {
        String select = isMapping ? "*" : SqlUtils.select(clazz);
        String tableName = SqlUtils.getTableName(clazz);
        if (!SqlUtils.isDefault(wrapper).booleanValue()) {
            String sqlSelect = wrapper.getSqlSelect();
            if (page != null && StringUtils.isNotBlank(page.getOrderByField())) {
                wrapper.orderBy(page.getOrderByField(), page.isAsc());
            }
            return String.format(SQL_LIST, StringUtils.isBlank(sqlSelect) ? select : sqlSelect, tableName, StringUtils.isNotBlank(wrapper.toString()) ? wrapper.toString() : "");
        }
        if (page != null) {
            return SqlUtils.concatOrderBy(String.format(SQL_LIST, select, tableName, ""), page);
        }
        return String.format(SQL_LIST, select, tableName, "");
    }

    public static String sqlList(String sql, Wrapper wrapper, Page page) {
        if (!SqlUtils.isDefault(wrapper).booleanValue()) {
            if (page != null && StringUtils.isNotBlank(page.getOrderByField())) {
                wrapper.orderBy(page.getOrderByField(), page.isAsc());
            }
            sql = sql + wrapper.toString();
        }
        return sql;
    }

    public static String sqlList(Class clazz, Wrapper wrapper, Page page) {
        return SqlUtils.sqlList(clazz, false, wrapper, page);
    }

    public static String sqlCount(Class clazz, Wrapper wrapper) {
        String tableName = SqlUtils.getTableName(clazz);
        if (!SqlUtils.isDefault(wrapper).booleanValue()) {
            return String.format(SQL_COUNT, tableName, wrapper.toString());
        }
        return String.format(SQL_COUNT, tableName, "");
    }

    public static String getTableName(Class clazz) {
        EntityInfo entityInfo = EntityInfoUtils.getEntityInfo(clazz);
        String tableName = entityInfo.getTableName();
        if (StringUtils.isBlank(tableName)) {
            throw new HibernatePlusException("Error: Entity @Table Not Found!");
        }
        return tableName;
    }

    public static <T extends Convert> String sqlDelete(Class<T> clazz, Wrapper wrapper) {
        String tableName = SqlUtils.getTableName(clazz);
        if (!SqlUtils.isDefault(wrapper).booleanValue()) {
            return String.format(SQL_DELETE, tableName, wrapper.toString());
        }
        return String.format(SQL_DELETE, tableName, "");
    }

    public static <T extends Convert> String sqlDelete(Class<T> clazz, Serializable id) {
        String tableName = SqlUtils.getTableName(clazz);
        String keyColumn = SqlUtils.getPrimaryKey(clazz);
        return String.format(SQL_DELETE, tableName, DeleteWrapper.instance().eq(keyColumn, id).toString());
    }

    public static <T extends Convert> String getPrimaryKey(Class<T> clazz) {
        EntityInfo entityInfo = EntityInfoUtils.getEntityInfo(clazz);
        String keyColumn = entityInfo.getKeyColumn();
        if (StringUtils.isBlank(keyColumn)) {
            throw new HibernatePlusException("The table does not have a primary key and can not perform operations!");
        }
        return keyColumn;
    }

    public static String sqlUpdate(Class clazz, Wrapper wrapper) {
        String tableName = SqlUtils.getTableName(clazz);
        Map<String, String> setMap = wrapper.getSetMap();
        Assert.notEmpty(setMap);
        Iterator<Map.Entry<String, String>> iterator = wrapper.getSetMap().entrySet().iterator();
        int _size = setMap.size();
        int i = 1;
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String key = entry.getKey();
            String value = entry.getValue();
            builder.append(String.format("%s = %s", key, value));
            if (i != _size) {
                builder.append(",");
            }
            ++i;
        }
        if (!SqlUtils.isDefault(wrapper).booleanValue()) {
            return String.format(SQL_UPDATE, tableName, builder.toString(), wrapper.toString());
        }
        return String.format(SQL_UPDATE, tableName, builder.toString(), "");
    }

    public static String select(Class clazz) {
        return EntityInfoUtils.getEntityInfo(clazz).getSelect();
    }

    public static Boolean isDefault(Wrapper wrapper) {
        return wrapper == null || wrapper == UpdateWrapper.DEFAULT || wrapper == SelectWrapper.DEFAULT || wrapper == DeleteWrapper.DEFAULT;
    }
}

