package com.bcxin.rest.web.apis.utils;

import org.springframework.util.StringUtils;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class ServletRequestUtil {
    private static final String AUTHENTICATION="Authorization";
    private static final String EMPLOYEE_AUTHENTICATION="accesstoken";//""employee_token";

    public static String getBearerToken(ServletRequest servletRequest) {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        String authentication = request.getHeader(AUTHENTICATION);

        if (!StringUtils.hasLength(authentication)) {
            return null;
        }

        if (!authentication.contains("Bearer ")) {
            return null;
        }

        return authentication.substring(7);
    }

    public static String getEmployeeToken(ServletRequest servletRequest) {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        String employeeToken = request.getHeader(EMPLOYEE_AUTHENTICATION);

        if (!StringUtils.hasLength(employeeToken)) {
            return null;
        }

        return employeeToken;
    }
}
