package com.bcxin.rest.web.apis.controllers;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.api.interfaces.tenants.SingleLoginRpcProvider;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Auther linqinglin
 * @date 2021/6/6 9:50
 */
@RestController
@RequestMapping("/sso/test")
public class SingleLoginTestController {


    private final SingleLoginRpcProvider singleLoginRpcProvider;

    public SingleLoginTestController(SingleLoginRpcProvider singleLoginRpcProvider){
        this.singleLoginRpcProvider = singleLoginRpcProvider;
    }

    @RequestMapping("/getjhuser")
    public JSONObject getjhuser(){
        JSONObject result = new JSONObject();
        String userObject = "{\"NAME\":\"奇葩2\",\"SUNIT_CODE\":\"10001\",\"NSTATION_NO\":\"20001\",\"SSTATION_NAME\":\"管理员1\"}";
        result.put("code","0");
        result.put("userObject", singleLoginRpcProvider.encryptByAES(userObject));
        return result;
    }

    @RequestMapping("/getorgcode")
    public JSONObject getorgcode(){
        JSONObject result = new JSONObject();
        String dwObject = "{\"ORGNAME\":\"研究部2\"}";
        result.put("code","0");
        result.put("dwObject", singleLoginRpcProvider.encryptByAES(dwObject));
        return result;
    }

    @RequestMapping("/getmenu")
    public JSONObject getmenu(){
        JSONObject result = new JSONObject();
        String menuObject = "{\"list\":[{\"MENU_ID\":\"__OPzznSuHUuhY38LHvom\"},{\"MENU_ID\":\"__aghmSNNMySGWRDZL9su\"},{\"MENU_ID\":\"__xmKvNf0mAcnMPmoxrMX\"},{\"MENU_ID\":\"__4IoxzAiFleGQ96HPbQA\"}]}";
        result.put("code","0");
        result.put("menuObject", singleLoginRpcProvider.encryptByAES(menuObject));
        return result;
    }

}
