package com.bcxin.rest.web.apis.controllers;

import com.bcxin.Infrastructures.enums.InvitedType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.api.interfaces.buses.enums.SmsBusinessType;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.identities.requests.SmsRequest;
import com.bcxin.api.interfaces.security.AttendSitePersonRpcProvider;
import com.bcxin.api.interfaces.tenants.EmployeeRpcProvider;
import com.bcxin.api.interfaces.tenants.InviteAttendSiteRpcProvider;
import com.bcxin.api.interfaces.tenants.InvitedToJoinQueuesRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.employees.EmployeeRequest;
import com.bcxin.api.interfaces.tenants.requests.employees.UpdateEmployeeRequest;
import com.bcxin.api.interfaces.tenants.responses.InviteAttendSiteResponse;
import com.bcxin.api.interfaces.tenants.responses.InviteUserGetResponse;
import io.swagger.annotations.ApiOperation;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@Validated
@RestController
@RequestMapping("/tenant/inviteAttendSite")
public class InviteAttendSiteController extends ControllerAbstract {

    private final InviteAttendSiteRpcProvider inviteAttendSiteRpcProvider;

    private final AttendSitePersonRpcProvider attendSitePersonRpcProvider;

    private final EmployeeRpcProvider employeeRpcProvide;

    private final IdentityRpcProvider identityRpcProvider;

    private final InvitedToJoinQueuesRpcProvider invitedToJoinQueuesRpcProvider;

    public InviteAttendSiteController(InviteAttendSiteRpcProvider inviteAttendSiteRpcProvider,
                                      AttendSitePersonRpcProvider attendSitePersonRpcProvider,
                                      EmployeeRpcProvider employeeRpcProvide,
                                      IdentityRpcProvider identityRpcProvider, InvitedToJoinQueuesRpcProvider invitedToJoinQueuesRpcProvider) {
        this.inviteAttendSiteRpcProvider = inviteAttendSiteRpcProvider;
        this.attendSitePersonRpcProvider = attendSitePersonRpcProvider;
        this.employeeRpcProvide = employeeRpcProvide;
        this.identityRpcProvider = identityRpcProvider;
        this.invitedToJoinQueuesRpcProvider = invitedToJoinQueuesRpcProvider;
    }


    @GetMapping("/getUnOvertime/{id}")
    public ResponseEntity<InviteAttendSiteResponse> getUnOvertime(@PathVariable String id) {
        InviteAttendSiteResponse responses = this.inviteAttendSiteRpcProvider.getUnOvertime(id);
        if(responses == null){
            return this.error("该邀请不存在或者已截止！");
        }

        return this.ok(responses);
    }

    @GetMapping("/getSmsCode/{phone}")
    public ResponseEntity getSmsCode(@PathVariable String phone) {
        identityRpcProvider.sendCode(SmsRequest.create(SmsBusinessType.InviteAttendSite,phone));
        return this.ok();
    }

    @PostMapping("/getEmployee/{organizationId}")
    public ResponseEntity getEmployee(@PathVariable String organizationId,@RequestBody SmsRequest request) {
        request.setBusinessType(SmsBusinessType.InviteAttendSite);
        if(!identityRpcProvider.checkCode(request)){
            return this.ok(employeeRpcProvide.getByOrganIdAndPhone(organizationId,request.getPhone()));
        }
        return this.error("验证码验证不通过");
    }

    @ApiOperation(value = "新增企业职员信息-邀请入职")
    @PostMapping("add-employees/{inviteAttendSiteId}")
    public ResponseEntity addInviteEmployees(@PathVariable String inviteAttendSiteId,
                                             @Valid @RequestBody EmployeeRequest request) {
        this.invitedToJoinQueuesRpcProvider.create(InvitedType.InviteAttend,inviteAttendSiteId,request);
        return this.ok();


        /*request.setDepartId(inviteAttendSite.getDepartId());
        request.setOccupationType(inviteAttendSite.getOccupationType());
        request.setAreaCode(inviteAttendSite.getAreaCode());
        request.setOperator(inviteAttendSite.getCreator());
        String employeeId = null;
        try {
            employeeId = this.employeeRpcProvide.create(inviteAttendSite.getOrganizationId(),request);
        }catch (Exception e){
            if(e instanceof ConflictTenantException){
                InviteUserGetResponse employee = employeeRpcProvide.getByOrganIdAndIdNum(inviteAttendSite.getOrganizationId(), request.getCredential().getNumber());
                if(!OccupationType.SecurityGuard.equals(request.getOccupationType())){
                    return this.error("已入职该企业，职业不符！");
                }
                employeeId = employee.getId();
                UpdateEmployeeRequest updateEmployeeRequest = new UpdateEmployeeRequest();
                updateEmployeeRequest.setDepartId(request.getDepartId());
                this.employeeRpcProvide.update(inviteAttendSite.getOrganizationId(),employeeId,updateEmployeeRequest);
                request.getCredential().setType(employee.getCredentialType());
                request.getCredential().setNumber(employee.getCredentialNumber());
            }else{
                throw e;
            }

        }finally {
            if(StringUtils.isNotEmpty(employeeId)) {
                this.attendSitePersonRpcProvider.create(inviteAttendSite, request, employeeId);
            }
        }*/


    }

}
