/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.components;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.api.interfaces.buses.MessageRpcProvider;
import com.bcxin.api.interfaces.buses.enums.MessageType;
import com.bcxin.api.interfaces.buses.requests.MessageRequest;
import com.bcxin.identity.domains.components.ForgetPasswordExecutorImpl;
import com.bcxin.identity.domains.components.commands.ForgetPasswordActionExecuteCommand;
import com.bcxin.identity.domains.services.commandResult.PrepareResetPasswordCommandResult;
import com.bcxin.identity.domains.utils.JwtUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.springframework.stereotype.Component;

@Component(value="SmsForgetPasswordExecutor")
public class SmsForgetPasswordExecutor
implements ForgetPasswordExecutorImpl {
    private final MessageRpcProvider messageRpcProvider;

    public SmsForgetPasswordExecutor(MessageRpcProvider messageRpcProvider) {
        this.messageRpcProvider = messageRpcProvider;
    }

    @Override
    public PrepareResetPasswordCommandResult execute(ForgetPasswordActionExecuteCommand command) {
        command.validate();
        HashMap<String, String> huaWeiSmsContent = new HashMap<String, String>();
        huaWeiSmsContent.put("smsCode", "B02");
        String code = SmsForgetPasswordExecutor.verificationCode();
        ArrayList<String> sendParams = new ArrayList<String>();
        sendParams.add(code);
        huaWeiSmsContent.put("params", JSON.toJSONString(sendParams));
        huaWeiSmsContent.put("mobile", command.getMobile());
        this.messageRpcProvider.dispatch(MessageRequest.create((MessageType)MessageType.SMS, huaWeiSmsContent));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("GetPasswordType", "1");
        map.put("code", code);
        map.put("loginName", command.getLoginName());
        map.put("time", DateUtil.now());
        String json = JSON.toJSONString(map);
        String jwt = JwtUtil.createJwt(json);
        return PrepareResetPasswordCommandResult.create(jwt, true, "200", command.getMobile());
    }

    public static String verificationCode() {
        Random random = new Random();
        String result = "";
        for (int i = 0; i < 6; ++i) {
            result = result + random.nextInt(10);
        }
        return result;
    }
}

