package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import lombok.Getter;

@Getter
public class TenantCredentialChangedEvent extends DomainEventAbstract<CredentialType> {
    private final String tenantUserId;
    private final String name;
    private final String telephone;
    private final String number;

    /**
     * Create a new {@code ApplicationEvent}.
     *
     * @param data
     * @param number
     */
    public TenantCredentialChangedEvent(String tenantUserId,String name, CredentialType data, String telephone,String number) {
        super(data);
        this.name = name;
        this.number = number;
        this.telephone = telephone;
        this.tenantUserId = tenantUserId;
    }

    public static TenantCredentialChangedEvent create(String tenantUserId, String name, CredentialType data, String telephone,String number) {
        return new TenantCredentialChangedEvent(tenantUserId, name, data, telephone, number);
    }
}
