package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.util.Collection;

@Getter
public class EmployeeBeforeEntryValidationEvent extends DomainEventAbstract<String> {

    private final String areaCode;
    private final String organizationId;
    private final Collection<TenantUserOccupationTypeInfo> tenantUsers;

    public EmployeeBeforeEntryValidationEvent(
            String areaCode,String organizationId,
            Collection<TenantUserOccupationTypeInfo> tenantUsers) {
        /**
         * 当areaCode为空得时候; 会造成null 异常
         */
        super(StringUtils.hasLength(areaCode)?areaCode:"");
        this.areaCode = areaCode;
        this.organizationId = organizationId;
        this.tenantUsers = tenantUsers;
    }


    /**
     * 验证职业类型, 证件类型, 根据区域进行年龄判断等等
     * 针对RT和内网环境，同时验证手机号(RT这个是账号)是否被其他身份证所占用
     * @param areaCode
     * @param tenantUsers
     * @return
     */
    public static EmployeeBeforeEntryValidationEvent create(String areaCode,String organizationId,  Collection<TenantUserOccupationTypeInfo> tenantUsers) {
        return new EmployeeBeforeEntryValidationEvent(areaCode,organizationId, tenantUsers);
    }

    @Getter
    public static class TenantUserOccupationTypeInfo {
        private final String tenantUserId;
        private final String name;
        private final OccupationType occupationType;
        private final CredentialType credentialType;
        private final String credentialNumber;
        private final String telephone;

        private final boolean isBack;

        public TenantUserOccupationTypeInfo(String tenantUserId, String name, OccupationType occupationType,
                                            CredentialType credentialType, String credentialNumber,
                                            String telephone, boolean isBack) {
            this.tenantUserId = tenantUserId;
            this.name = name;
            this.occupationType = occupationType;
            this.credentialType = credentialType;
            this.credentialNumber = credentialNumber;
            this.telephone = telephone;
            this.isBack = isBack;
        }

        public static TenantUserOccupationTypeInfo create(String tenantUserId, String name, OccupationType occupationType,
                                                          CredentialType credentialType, String credentialNumber,
                                                          String telephone, boolean isBack) {
            return new TenantUserOccupationTypeInfo(tenantUserId, name, occupationType, credentialType, credentialNumber,
                    telephone, isBack);
        }
    }
}