package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.PersonStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Date;

@Getter
public class UpdateEmployeeRequestCommand extends CommandAbstract {
    private final String organizationId;

    private final String id;
    /**
     * 所属本部门
     */
    private final String departId;

    /**
     * 入职时间
     */
    @NotNull
    private final Date hiredTime;

    private final String superiorId;

    private final String position;

    private final Date positiveDate;

    /**
     * 所属部门
     */
    @NotEmpty
    private Collection<String> departIds;

    /**
     * 面谈记录
     */
    @ApiModelProperty(value = "面谈记录")
    private String interview;

    /**
     * 员工状态（选填，单选：全职/兼职/试用/实习）
     */
    @ApiModelProperty(value = "员工状态")
    private final PersonStatus personStatus;

    /**
     * 试用期 数字
     */
    @ApiModelProperty(value = "试用期")
    private final String probation;


    /**
     * 原定转正日期 年月日
     */
    @ApiModelProperty(value = "原定转正日期")
    private final Date planPositiveDate;

    /**
     * 薪资
     */
    @ApiModelProperty(value = "薪资")
    private final String salary;

    public UpdateEmployeeRequestCommand(String organizationId, String id, String departId,
                                        Date hiredTime, String superiorId, String position,
                                        Date positiveDate,Collection<String> departIds,
                                        String interview,
                                        PersonStatus personStatus,
                                        String probation,
                                        Date planPositiveDate,
                                        String salary) {
        this.organizationId = organizationId;
        this.id = id;
        this.departId = departId;
        this.hiredTime = hiredTime;
        this.superiorId = superiorId;
        this.position = position;
        this.positiveDate = positiveDate;
        this.departIds = departIds;
        this.interview = interview;
        this.personStatus = personStatus;
        this.probation = probation;
        this.planPositiveDate = planPositiveDate;
        this.salary = salary;
    }

    public static UpdateEmployeeRequestCommand create(String organizationId,String id, String departId,
                                                      Date hiredTime, String superiorId, String position,
                                                      Date positiveDate,Collection<String> departIds,
                                                      String interview,
                                                      PersonStatus personStatus,
                                                      String probation,
                                                      Date planPositiveDate,
                                                      String salary) {
        return new UpdateEmployeeRequestCommand(organizationId, id, departId, hiredTime, superiorId, position, positiveDate,departIds,
                interview,
                personStatus,
                probation,
                planPositiveDate,
                salary);
    }

}
