package com.bcxin.tenant.domain.repositories.dtos;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

@Data
public class OrganizationExportDto  implements Serializable {

    private static final long serialVersionUID = 4530474987109938356L;

    @ExcelProperty("公司名称")
    @ColumnWidth(30)
    private String name;
    @ExcelProperty("行业类型")
    @ColumnWidth(20)
    private String industryCode;
    @ExcelProperty("机构类型")
    @ColumnWidth(20)
    private String institutionalCode;
    @ExcelProperty("注册地区")
    @ColumnWidth(20)
    private String registerPlaceName;
    @ExcelProperty("经营地区")
    @ColumnWidth(20)
    private String businessPlaceName;
    @ExcelProperty("监管地区")
    @ColumnWidth(20)
    private String superviseRegionName;
    @ExcelProperty("监管机构")
    @ColumnWidth(30)
    private String superviseDepartName;
    @ExcelProperty("审批状态")
    @ColumnWidth(10)
    private String approvedStatusName;
    @ExcelProperty("创建时间")
    @ColumnWidth(18)
    private String createdTime;
    @ExcelProperty("审批时间")
    @ColumnWidth(18)
    private String approvedTime;

    public OrganizationExportDto(
            String name,
            ApprovedStatus status,
            String industryCode,
            String institutionalCode,
            LocationValueType placeOfRegister,
            LocationValueType placeOfBusiness,
            Date createdTime,
            Date approveTime,
            String superviseRegionName,
            String superviseDepartName
    ) {
        this.name = name;
        if (status == null) {
            this.approvedStatusName = "待审批";
        } else {
            switch (status) {
                case Passed:
                    this.approvedStatusName = "审批通过";
                    break;
                case NoPassed:
                    this.approvedStatusName = "不通过";
                    break;
                default:
                    this.approvedStatusName = "待审批";
                    break;
            }
        }
        if (StringUtils.isNotBlank(industryCode)) {
            switch (industryCode) {
                case "01" :
                    this.industryCode = "保安行业";
                    break;
                case "02" :
                    this.industryCode = "大活行业";
                    break;
                case "03" :
                    this.industryCode = "其他";
                    break;
                case "04" :
                    this.industryCode = "内保行业";
                    break;
                case "05" :
                    this.industryCode = "合作行业";
                    break;
                case "06" :
                    this.industryCode = "群防群治行业";
                    break;
                default:
                    break;

            }
        }
        if (StringUtils.isNotBlank(institutionalCode)) {
            switch (institutionalCode) {
                case "0101" :
                    this.institutionalCode = "保安协会";
                    break;
                case "0102" :
                    this.institutionalCode = "保安服务公司";
                    break;
                case "0103" :
                    this.institutionalCode = "保安培训单位";
                    break;
                case "0104" :
                    this.institutionalCode = "自行招用保安员单位";
                    break;
                case "0105" :
                    this.institutionalCode = "省级保安协会";
                    break;
                case "0106" :
                    this.institutionalCode = "市级保安协会";
                    break;
                case "0107" :
                    this.institutionalCode = "省级保安监管";
                    break;
                case "0108" :
                    this.institutionalCode = "市级保安监管";
                    break;
                case "0109" :
                    this.institutionalCode = "区县级保安监管";
                    break;
                case "0110" :
                    this.institutionalCode = "派出所监管机构";
                    break;
                case "0201" :
                    this.institutionalCode = "活动承办方";
                    break;
                case "0202" :
                    this.institutionalCode = "政府单位";
                    break;
                case "0203" :
                    this.institutionalCode = "风评机构";
                    break;
                case "0204" :
                    this.institutionalCode = "服务机构";
                    break;
                case "0205" :
                    this.institutionalCode = "公安机构";
                    break;
                case "0207" :
                    this.institutionalCode = "省级大活监管";
                    break;
                case "0208" :
                    this.institutionalCode = "市级大活监管";
                    break;
                case "0209" :
                    this.institutionalCode = "区县级大活监管";
                    break;
                case "0210" :
                    this.institutionalCode = "派出所监管机构";
                    break;
                case "0211":
                    this.institutionalCode = "活动运营方";
                    break;
                case "0212":
                    this.institutionalCode = "组委会";
                    break;
                case "0214":
                    this.institutionalCode = "体育局";
                    break;
                case "0215":
                    this.institutionalCode = "文旅局";
                    break;
                case "0216":
                    this.institutionalCode = "卫健委";
                    break;
                case "0217":
                    this.institutionalCode = "政法委";
                    break;
                case "0218":
                    this.institutionalCode = "共青团";
                    break;
                case "0219":
                    this.institutionalCode = "社团志愿者团队";
                    break;
                case "0221":
                    this.institutionalCode = "无人机反制公司";
                    break;
                case "0222":
                    this.institutionalCode = "医疗服务团队";
                    break;
                case "0223":
                    this.institutionalCode = "裁判服务团队";
                    break;
                case "0301" :
                    this.institutionalCode = "其他";
                    break;
                case "0302" :
                    this.institutionalCode = "培训机构会员单位";
                    break;
                case "0401" :
                    this.institutionalCode = "医疗单位";
                    break;
                case "0402" :
                    this.institutionalCode = "文博单位";
                    break;
                case "0403" :
                    this.institutionalCode = "中小学、幼儿园";
                    break;
                case "0404" :
                    this.institutionalCode = "高校";
                    break;
                case "0405" :
                    this.institutionalCode = "金融单位";
                    break;
                case "0406" :
                    this.institutionalCode = "党政机关";
                    break;
                case "0407" :
                    this.institutionalCode = "省级内保监管";
                    break;
                case "0408" :
                    this.institutionalCode = "市级内保监管";
                    break;
                case "0409" :
                    this.institutionalCode = "区县级内保监管";
                    break;
                case "0410" :
                    this.institutionalCode = "派出所监管机构";
                    break;
                case "0501" :
                    this.institutionalCode = "渠道合作方";
                    break;
                case "0502" :
                    this.institutionalCode = "供应商";
                    break;
                case "0601" :
                    this.institutionalCode = "社区警务团队";
                    break;
                case "0607" :
                    this.institutionalCode = "省级联防监管";
                    break;
                case "0608" :
                    this.institutionalCode = "市级联防监管";
                    break;
                case "0609" :
                    this.institutionalCode = "区县级联防监管";
                    break;
                case "0610" :
                    this.institutionalCode = "派出所监管机构";
                    break;
                default:
                    break;

            }
        }
        if (placeOfRegister != null) {
            this.registerPlaceName = placeOfRegister.getShortLocation();
        }
        if (placeOfBusiness != null) {
            businessPlaceName = placeOfBusiness.getShortLocation();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (createdTime == null) {
            this.createdTime = null;
        } else {
            this.createdTime = dateFormat.format(createdTime);
        }
        if (approveTime == null) {
            this.approvedTime = null;
        } else {
            this.approvedTime = dateFormat.format(approveTime);
        }
        this.superviseRegionName = superviseRegionName;
        this.superviseDepartName = superviseDepartName;
    }
}
