package com.bcxin.tenant.domain.repositories.dtos;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;

@Getter
public class DepartmentAdminExportDto implements Serializable {
    @ExcelIgnore
    private final String employeeId;
    @ExcelProperty("姓名")
    private final String name;
    @ExcelProperty("手机号")
    private final String telephone;
    @ExcelProperty("所在部门")
    private final String departName;
    @ExcelProperty("可管理的部门")
    private final String managedAdminNames;

    public DepartmentAdminExportDto(String employeeId,
                                  String name,
                                  String telephone,
                                  String departName,
                                  String managedAdminNames) {
        this.employeeId = employeeId;
        this.name = name;
        this.telephone = telephone;
        this.departName = departName;
        this.managedAdminNames = managedAdminNames;
    }

    public static DepartmentAdminExportDto create(String employeeId,
                                                String name,
                                                String telephone,
                                                String departName,
                                                String managedAdminNames) {
        return new DepartmentAdminExportDto(employeeId, name,telephone, departName, managedAdminNames);
    }
}
