/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Table(name="tenant_department_admins")
@Entity
public class DepartmentAdminEntity
extends EntityAbstract
implements IAggregate {
    @Id
    private String id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="organization_id", referencedColumnName="id", nullable=false, updatable=false)
    private OrganizationEntity organization;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="department_id", referencedColumnName="id", nullable=false, updatable=false)
    private DepartmentEntity department;
    @Column(name="department_index_tree")
    private String departmentIndexTree;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="employee_id", referencedColumnName="id", nullable=false, updatable=false)
    private EmployeeEntity employee;
    @Column(name="created_time", updatable=false, nullable=false)
    private Timestamp createdTime = Timestamp.from(Instant.now());

    protected DepartmentAdminEntity() {
    }

    public static DepartmentAdminEntity create(DepartmentEntity department, EmployeeEntity employee) {
        DepartmentAdminEntity departmentAdmin = new DepartmentAdminEntity();
        departmentAdmin.setId(UUIDUtil.getShortUuid());
        departmentAdmin.setDepartment(department);
        departmentAdmin.setDepartmentIndexTree(department.getIndexTree());
        departmentAdmin.setEmployee(employee);
        departmentAdmin.setOrganization(department.getOrganization());
        return departmentAdmin;
    }

    public void changeIndexTree(String departmentIndexTree) {
        this.setDepartmentIndexTree(departmentIndexTree);
    }

    public String getId() {
        return this.id;
    }

    public OrganizationEntity getOrganization() {
        return this.organization;
    }

    public DepartmentEntity getDepartment() {
        return this.department;
    }

    public String getDepartmentIndexTree() {
        return this.departmentIndexTree;
    }

    public EmployeeEntity getEmployee() {
        return this.employee;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setOrganization(OrganizationEntity organization) {
        this.organization = organization;
    }

    protected void setDepartment(DepartmentEntity department) {
        this.department = department;
    }

    protected void setDepartmentIndexTree(String departmentIndexTree) {
        this.departmentIndexTree = departmentIndexTree;
    }

    protected void setEmployee(EmployeeEntity employee) {
        this.employee = employee;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }
}

