/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.repositories.OrganizationAdminRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.services.OrganizationAdminService;
import com.bcxin.tenant.domain.services.commands.organizationAdmins.CreateOrganizationAdminCommand;
import com.bcxin.tenant.domain.services.commands.organizationAdmins.DeleteOrganizationAdminCommand;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrganizationAdminServiceImpl
implements OrganizationAdminService {
    private final OrganizationAdminRepository organizationAdminRepository;
    private final EmployeeRepository employeeRepository;
    private final UnitWork unitWork;
    private final OrganizationRepository organizationRepository;

    public OrganizationAdminServiceImpl(OrganizationAdminRepository organizationAdminRepository, EmployeeRepository employeeRepository, UnitWork unitWork, OrganizationRepository organizationRepository) {
        this.organizationAdminRepository = organizationAdminRepository;
        this.employeeRepository = employeeRepository;
        this.unitWork = unitWork;
        this.organizationRepository = organizationRepository;
    }

    @Override
    public void dispatch(CreateOrganizationAdminCommand command) {
        command.validate();
        Collection<EmployeeEntity> employees = this.employeeRepository.getByIds(command.getOrganizationId(), command.getEmployeeIds());
        Collection notFoundEmployeeIds = command.getEmployeeIds().stream().filter(ii -> !employees.stream().anyMatch(ix -> ix.getId().equals(ii))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)notFoundEmployeeIds)) {
            throw new NotFoundTenantException(String.format("\u627e\u4e0d\u5230\u804c\u5458(%s)", notFoundEmployeeIds.stream().collect(Collectors.joining(","))));
        }
        Collection employeeAdmins = employees.stream().filter(ii -> ii.getDomainAdmin() == TrueFalseStatus.True).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)employeeAdmins)) {
            throw new NotAllowedTenantException(String.format("\u804c\u5458\u5df2\u7ecf\u662f\u7ec4\u7ec7\u7ba1\u7406\u5458(%s)", employeeAdmins.stream().map(ix -> ix.getId()).collect(Collectors.joining(","))));
        }
        this.unitWork.executeTran(() -> employees.forEach(ix -> {
            ix.markAsDomainAdmin(true, false);
            this.employeeRepository.save((EntityAbstract)ix);
        }));
    }

    @Override
    public void dispatch(DeleteOrganizationAdminCommand command) {
        command.validate();
        Collection<EmployeeEntity> employeeAdmins = this.employeeRepository.getByIds(command.getOrganizationId(), command.getIds());
        Collection notFoundOrganizationAdminIds = command.getIds().stream().filter(ii -> !employeeAdmins.stream().anyMatch(ix -> ix.getDomainAdmin() == TrueFalseStatus.True && ix.getId().equals(ii))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)notFoundOrganizationAdminIds)) {
            throw new NotFoundTenantException(String.format("\u627e\u4e0d\u5230\u7ec4\u7ec7\u7ba1\u7406\u5458(%s)", notFoundOrganizationAdminIds.stream().collect(Collectors.joining(","))));
        }
        this.unitWork.executeTran(() -> employeeAdmins.forEach(ix -> {
            ix.markAsDomainAdmin(false, false);
            this.employeeRepository.save((EntityAbstract)ix);
        }));
    }

    @Override
    public void dispatch(OrganizationEntity organization) {
        throw new BadTenantException("\u672a\u5b9e\u73b0");
    }
}

