/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.PlatformResetPasswordRequest;
import org.apache.commons.lang3.StringUtils;

public class PlatformResetPasswordCommand
extends CommandAbstract {
    private final String tenantUserId;
    private final String employeeId;
    private final String operateUserId;
    private final String ipAddress;

    public PlatformResetPasswordCommand(String tenantUserId, String employeeId, String operateUserId, String ipAddress) {
        this.tenantUserId = tenantUserId;
        this.employeeId = employeeId;
        this.operateUserId = operateUserId;
        this.ipAddress = ipAddress;
    }

    public static PlatformResetPasswordCommand create(PlatformResetPasswordRequest request) {
        return new PlatformResetPasswordCommand(request.getTenantUserId(), request.getEmployeeId(), request.getOperateUserId(), request.getIpAddress());
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.getTenantUserId())) {
            throw new ArgumentTenantException("\u5f53\u524d\u767b\u5f55\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (!userModel.getId().equals(this.getTenantUserId())) {
            throw new ArgumentTenantException("\u5f53\u524d\u767b\u5f55\u7684\u7528\u6237id\u548c\u6240\u4f20\u53c2\u6570\u4e0d\u4e00\u81f4");
        }
        if (StringUtils.isBlank((CharSequence)this.getEmployeeId())) {
            throw new ArgumentTenantException("\u5f53\u524d\u767b\u5f55\u7684\u804c\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.getOperateUserId())) {
            throw new ArgumentTenantException("\u88ab\u64cd\u4f5c\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public String getTenantUserId() {
        return this.tenantUserId;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public String getOperateUserId() {
        return this.operateUserId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }
}

