/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.exceptions;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.utils.StringUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class EntryEmployeeValidationException
extends ArgumentTenantException {
    private final Collection<EntryNotAllowedInfo> notAllowedCompanyInfos;

    public EntryEmployeeValidationException(String msg, Collection<EntryNotAllowedInfo> notAllowedCompanyInfos) {
        super(msg);
        this.notAllowedCompanyInfos = notAllowedCompanyInfos;
    }

    public String getMessage() {
        if (CollectionUtils.isEmpty(this.notAllowedCompanyInfos)) {
            return super.getMessage();
        }
        return String.format("%s %s", super.getMessage(), this.notAllowedCompanyInfos.stream().map(ii -> ii.toString()).collect(Collectors.joining(",")));
    }

    public String getMatchMessage(String telephone, CredentialType credentialType, String credentialNumber) {
        if (CollectionUtils.isEmpty(this.getNotAllowedCompanyInfos())) {
            return null;
        }
        return this.getNotAllowedCompanyInfos().stream().filter(ii -> StringUtil.equal((String)ii.getTelephone(), (String)telephone) && StringUtil.equal((String)ii.getCredentialNumber(), (String)credentialNumber) && credentialType == ii.getCredentialType()).map(ii -> ii.getMessage()).collect(Collectors.joining(";"));
    }

    public static EntryEmployeeValidationException create(String msg, Collection<EntryNotAllowedInfo> notAllowedCompanyInfos) {
        return new EntryEmployeeValidationException(msg, notAllowedCompanyInfos);
    }

    public Collection<EntryNotAllowedInfo> getNotAllowedCompanyInfos() {
        return this.notAllowedCompanyInfos;
    }

    public static class EntryNotAllowedInfo
    implements Serializable {
        private final String message;
        private final String name;
        private final String telephone;
        private final CredentialType credentialType;
        private final String credentialNumber;

        public EntryNotAllowedInfo(String name, String message, String telephone, CredentialType credentialType, String credentialNumber) {
            this.message = message;
            this.name = name;
            this.telephone = telephone;
            this.credentialType = credentialType;
            this.credentialNumber = credentialNumber;
        }

        public static EntryNotAllowedInfo create(String name, String message, String telephone, CredentialType credentialType, String credentialNumber) {
            return new EntryNotAllowedInfo(name, message, telephone, credentialType, credentialNumber);
        }

        public String toString() {
            return this.getMessage();
        }

        public String getMessage() {
            return this.message;
        }

        public String getName() {
            return this.name;
        }

        public String getTelephone() {
            return this.telephone;
        }

        public CredentialType getCredentialType() {
            return this.credentialType;
        }

        public String getCredentialNumber() {
            return this.credentialNumber;
        }
    }
}

